/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public final class Utils {
    private Utils() {
    }

    public static String encodeParameterValue(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
    }

    public static boolean isDateExpiring(Date date, int seconds) {
        Calendar expirationDate = Calendar.getInstance();
        expirationDate.setTime(date);
        expirationDate.add(13, -seconds);
        return expirationDate.before(Calendar.getInstance());
    }

    public static Properties loadConfig(String file) throws IOException {
        String filename = file + ".properties";
        Properties config = new Properties();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        if (is == null) {
            throw new IOException(filename + " could not be loaded.");
        }
        config.load(is);
        return config;
    }
}

