/*
 * Decompiled with CFR 0.152.
 */
package com.bynder.sdk.configuration;

import com.bynder.sdk.configuration.HttpConnectionSettings;
import com.bynder.sdk.configuration.OAuthSettings;
import java.net.URL;

public class Configuration {
    private URL baseUrl;
    private OAuthSettings oauthSettings;
    private HttpConnectionSettings httpConnectionSettings;
    private String permanentToken;

    private Configuration() {
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public OAuthSettings getOAuthSettings() {
        return this.oauthSettings;
    }

    public HttpConnectionSettings getHttpConnectionSettings() {
        return this.httpConnectionSettings;
    }

    public String getPermanentToken() {
        return this.permanentToken;
    }

    public static class Builder {
        private URL baseUrl;
        private OAuthSettings oauthSettings;
        private HttpConnectionSettings httpConnectionSettings;
        private String permanentToken;

        public Builder(URL baseUrl) {
            this.baseUrl = baseUrl;
            this.oauthSettings = new OAuthSettings();
            this.httpConnectionSettings = new HttpConnectionSettings();
        }

        public Builder setOAuthSettings(OAuthSettings oauthSettings) {
            this.oauthSettings = oauthSettings;
            return this;
        }

        public Builder setHttpConnectionSettings(HttpConnectionSettings httpConnectionSettings) {
            this.httpConnectionSettings = httpConnectionSettings;
            return this;
        }

        public Builder setPermanentToken(String permanentToken) {
            this.permanentToken = permanentToken;
            return this;
        }

        public Configuration build() {
            Configuration configuration = new Configuration();
            configuration.baseUrl = this.baseUrl;
            configuration.oauthSettings = this.oauthSettings;
            configuration.httpConnectionSettings = this.httpConnectionSettings;
            configuration.permanentToken = this.permanentToken;
            return configuration;
        }
    }
}

