/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.common.utils;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\u001a'\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0005\u00a2\u0006\u0002\u0010\u0006\u001a\n\u0010\u0007\u001a\u00020\u0003*\u00020\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0003\u001a<\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\r\u001a\u001e\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00130\u0015\u001a$\u0010\u0016\u001a\u00020\u0013*\u00020\u00142\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00130\u0017\u00a8\u0006\u0019"}, d2={"runWithPrintTime", "R", "name", "", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "fileSize", "", "isZipName", "", "matchPair", "Lkotlin/Pair;", "", "left", "right", "startIndex", "endIndex", "traverseFile", "", "Ljava/io/File;", "Lkotlin/Function1;", "unzip", "Lkotlin/Function2;", "", "rhea-build-common"})
public final class ExtensionsKt {
    public static final boolean isZipName(@NotNull String $this$isZipName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isZipName, (String)"$this$isZipName");
        return StringsKt.endsWith$default((String)$this$isZipName, (String)"jar", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$isZipName, (String)"aar", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$isZipName, (String)"zip", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$isZipName, (String)"apk", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String fileSize(long $this$fileSize) {
        if ($this$fileSize < (long)1024) {
            return String.valueOf($this$fileSize);
        }
        float kb = (float)$this$fileSize / (float)1024;
        if (kb < (float)1024) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%.2fKB";
            Object[] objectArray = new Object[]{Float.valueOf(kb)};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }
        float mb = kb / (float)1024;
        if (mb < (float)1024) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%.2fMB";
            Object[] objectArray = new Object[]{Float.valueOf(mb)};
            boolean bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            return string3;
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%.2fGB";
        Object[] objectArray = new Object[]{Float.valueOf(mb / (float)1024)};
        boolean bl = false;
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
        return string4;
    }

    public static final <R> R runWithPrintTime(@NotNull String name, @NotNull Function0<? extends R> action) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        long start = System.currentTimeMillis();
        Object r = action.invoke();
        String string = '[' + name + "] " + (System.currentTimeMillis() - start) + "ms";
        boolean bl = false;
        System.out.println((Object)string);
        return (R)r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unzip(@NotNull File $this$unzip, @NotNull Function2<? super String, ? super byte[], Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)$this$unzip, (String)"$this$unzip");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Closeable closeable = new ZipInputStream(new BufferedInputStream(new FileInputStream($this$unzip)));
        boolean bl = false;
        Throwable throwable = null;
        try {
            ZipInputStream zin = (ZipInputStream)closeable;
            boolean bl2 = false;
            ZipEntry zipEntry = zin.getNextEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory()) {
                    String string = zipEntry.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"zipEntry.name");
                    action.invoke((Object)string, (Object)ByteStreamsKt.readBytes((InputStream)zin));
                }
                zipEntry = zin.getNextEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public static final Pair<Integer, Integer> matchPair(@NotNull String $this$matchPair, @NotNull String left, @NotNull String right, int startIndex, int endIndex) throws IllegalArgumentException {
        Intrinsics.checkParameterIsNotNull((Object)$this$matchPair, (String)"$this$matchPair");
        Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        if (Intrinsics.areEqual((Object)left, (Object)right)) {
            throw (Throwable)new IllegalArgumentException("left can not be equals right:" + left);
        }
        int sl = StringsKt.indexOf$default((CharSequence)$this$matchPair, (String)left, (int)startIndex, (boolean)false, (int)4, null);
        if (sl < 0) {
            return null;
        }
        int start = sl + left.length();
        int stack = 1;
        while (stack != 0 && 0 < start && start < endIndex) {
            int startRight = StringsKt.indexOf$default((CharSequence)$this$matchPair, (String)right, (int)start, (boolean)false, (int)4, null);
            if (startRight < start) {
                throw (Throwable)new IllegalArgumentException("Can matchPair by " + left + " and " + right + " from:" + $this$matchPair);
            }
            int startLeft = StringsKt.indexOf$default((CharSequence)$this$matchPair, (String)left, (int)start, (boolean)false, (int)4, null);
            if (0 <= startLeft && startLeft < startRight) {
                ++stack;
                start = startLeft + left.length();
                continue;
            }
            --stack;
            start = startRight + right.length();
        }
        if (stack != 0) {
            throw (Throwable)new IllegalArgumentException("Can matchPair by " + left + " and " + right + " from:" + $this$matchPair);
        }
        return new Pair((Object)sl, (Object)start);
    }

    public static /* synthetic */ Pair matchPair$default(String string, String string2, String string3, int n, int n2, int n3, Object object) throws IllegalArgumentException {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = string.length();
        }
        return ExtensionsKt.matchPair(string, string2, string3, n, n2);
    }

    public static final void traverseFile(@NotNull File $this$traverseFile, @NotNull Function1<? super File, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)$this$traverseFile, (String)"$this$traverseFile");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        if ($this$traverseFile.isFile()) {
            action.invoke((Object)$this$traverseFile);
        }
        File[] fileArray = $this$traverseFile.listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            File[] fileArray2 = $this$forEach$iv;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = fileArray2[i];
                boolean bl = false;
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                ExtensionsKt.traverseFile(file, action);
            }
        }
    }
}

