/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.common.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0002J\u0016\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013J\u0010\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/bytedance/rheatrace/common/utils/FileUtil;", "", "()V", "BUFFER_SIZE", "", "TAG", "", "addZipEntry", "", "zipOutputStream", "Ljava/util/zip/ZipOutputStream;", "zipEntry", "Ljava/util/zip/ZipEntry;", "inputStream", "Ljava/io/InputStream;", "closeQuietly", "obj", "copyFileUsingStream", "source", "Ljava/io/File;", "dest", "isRealZipOrJar", "", "input", "readFileAsString", "filePath", "rhea-build-common"})
public final class FileUtil {
    private static final String TAG = "FileUtil";
    private static final int BUFFER_SIZE = 16384;
    public static final FileUtil INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRealZipOrJar(@NotNull File input) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        ZipFile zf = null;
        try {
            zf = new ZipFile(input);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        finally {
            this.closeQuietly(zf);
        }
        return bl;
    }

    private final void closeQuietly(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (Throwable throwable) {}
        } else {
            throw (Throwable)new IllegalArgumentException("obj " + obj + " is not closeable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyFileUsingStream(@NotNull File source, @NotNull File dest) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        FileInputStream is = null;
        FileOutputStream os = null;
        File parent = dest.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try {
            is = new FileInputStream(source);
            os = new FileOutputStream(dest, false);
            byte[] buffer = new byte[16384];
            Ref.IntRef length = new Ref.IntRef();
            while (true) {
                int n = is.read(buffer);
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                length.element = it;
                if (n > 0) {
                    os.write(buffer, 0, length.element);
                    continue;
                }
                break;
            }
        }
        finally {
            this.closeQuietly(is);
            this.closeQuietly(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String readFileAsString(@Nullable String filePath) {
        if (filePath == null) {
            return "";
        }
        if (!new File(filePath).exists()) {
            return "";
        }
        StringBuffer fileData = new StringBuffer();
        Reader fileReader = null;
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filePath);
            fileReader = new InputStreamReader(inputStream, "UTF-8");
            char[] buf = new char[16384];
            Ref.IntRef numRead = new Ref.IntRef();
            while (true) {
                int n = fileReader.read(buf);
                int n2 = 0;
                int n3 = 0;
                int it = n;
                boolean bl = false;
                numRead.element = it;
                if (n != -1) {
                    n2 = 0;
                    n3 = numRead.element;
                    boolean bl2 = false;
                    String readData = new String(buf, n2, n3);
                    fileData.append(readData);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String numRead = "";
            return numRead;
        }
        finally {
            try {
                this.closeQuietly(fileReader);
                this.closeQuietly(inputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String string = fileData.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileData.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addZipEntry(@NotNull ZipOutputStream zipOutputStream, @NotNull ZipEntry zipEntry, @NotNull InputStream inputStream) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)zipOutputStream, (String)"zipOutputStream");
        Intrinsics.checkParameterIsNotNull((Object)zipEntry, (String)"zipEntry");
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        try {
            zipOutputStream.putNextEntry(zipEntry);
            byte[] buffer = new byte[16384];
            Ref.IntRef length = new Ref.IntRef();
            while (true) {
                int n = inputStream.read(buffer, 0, buffer.length);
                boolean bl = false;
                boolean bl2 = false;
                int it = n;
                boolean bl3 = false;
                length.element = it;
                if (n != -1) {
                    zipOutputStream.write(buffer, 0, length.element);
                    zipOutputStream.flush();
                    continue;
                }
                break;
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        finally {
            this.closeQuietly(inputStream);
            zipOutputStream.closeEntry();
        }
    }

    private FileUtil() {
    }

    static {
        FileUtil fileUtil;
        INSTANCE = fileUtil = new FileUtil();
    }
}

