/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.common.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/bytedance/rheatrace/common/utils/JavaToClassFormat;", "", "()V", "DESC_BOOLEAN", "", "DESC_BYTE", "DESC_CHAR", "DESC_DOUBLE", "DESC_FLOAT", "DESC_INT", "DESC_LONG", "DESC_OBJECT", "DESC_SHORT", "DESC_VOID", "getMethodDescParams", "paramString", "getMethodDescReturn", "returnString", "parseJavaToDesc", "type", "rhea-build-common"})
public final class JavaToClassFormat {
    private static final String DESC_BYTE = "B";
    private static final String DESC_CHAR = "C";
    private static final String DESC_DOUBLE = "D";
    private static final String DESC_FLOAT = "F";
    private static final String DESC_INT = "I";
    private static final String DESC_LONG = "J";
    private static final String DESC_OBJECT = "L";
    private static final String DESC_SHORT = "S";
    private static final String DESC_BOOLEAN = "Z";
    private static final String DESC_VOID = "V";
    public static final JavaToClassFormat INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getMethodDescParams(@NotNull String paramString) {
        Intrinsics.checkParameterIsNotNull((Object)paramString, (String)"paramString");
        CharSequence charSequence = paramString;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return "()";
        }
        List params = StringsKt.split$default((CharSequence)paramString, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        StringBuilder byteParamStringBuilder = new StringBuilder();
        byteParamStringBuilder.append("(");
        int n = 0;
        int n2 = ((Collection)params).size();
        while (n < n2) {
            void i;
            byteParamStringBuilder.append(this.parseJavaToDesc((String)params.get((int)i)));
            ++i;
        }
        byteParamStringBuilder.append(")");
        String string = byteParamStringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"byteParamStringBuilder.toString()");
        return string;
    }

    @NotNull
    public final String getMethodDescReturn(@NotNull String returnString) {
        Intrinsics.checkParameterIsNotNull((Object)returnString, (String)"returnString");
        return this.parseJavaToDesc(returnString);
    }

    private final String parseJavaToDesc(String type) {
        StringBuilder stringBuilder = new StringBuilder();
        String param = StringsKt.replace$default((String)type, (String)" ", (String)"", (boolean)false, (int)4, null);
        if (StringsKt.endsWith$default((String)param, (String)"[]", (boolean)false, (int)2, null)) {
            stringBuilder.append("[");
            param = StringsKt.replace$default((String)param, (String)"[]", (String)"", (boolean)false, (int)4, null);
        }
        CharSequence charSequence = param;
        boolean bl = false;
        if (charSequence.length() > 0) {
            String string;
            switch (param) {
                case "": {
                    string = "";
                    break;
                }
                case "boolean": {
                    string = DESC_BOOLEAN;
                    break;
                }
                case "char": {
                    string = DESC_CHAR;
                    break;
                }
                case "byte": {
                    string = DESC_BYTE;
                    break;
                }
                case "short": {
                    string = DESC_SHORT;
                    break;
                }
                case "int": {
                    string = DESC_INT;
                    break;
                }
                case "float": {
                    string = DESC_FLOAT;
                    break;
                }
                case "long": {
                    string = DESC_LONG;
                    break;
                }
                case "double": {
                    string = DESC_DOUBLE;
                    break;
                }
                case "void": {
                    string = DESC_VOID;
                    break;
                }
                default: {
                    string = 'L' + param + ';';
                }
            }
            stringBuilder.append(string);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stringBuilder.toString()");
        return StringsKt.replace$default((String)string, (String)".", (String)"/", (boolean)false, (int)4, null);
    }

    private JavaToClassFormat() {
    }

    static {
        JavaToClassFormat javaToClassFormat;
        INSTANCE = javaToClassFormat = new JavaToClassFormat();
    }
}

