/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007J;\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00072\u001e\u0010\u000b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\r0\f\"\b\u0012\u0002\b\u0003\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/bytedance/rheatrace/common/utils/ReflectUtil;", "", "()V", "getDeclaredFieldRecursive", "Ljava/lang/reflect/Field;", "clazz", "fieldName", "", "getDeclaredMethodRecursive", "Ljava/lang/reflect/Method;", "methodName", "argTypes", "", "Ljava/lang/Class;", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "rhea-build-common"})
public final class ReflectUtil {
    public static final ReflectUtil INSTANCE;

    @NotNull
    public final Field getDeclaredFieldRecursive(@NotNull Object clazz, @NotNull String fieldName) throws NoSuchFieldException, ClassNotFoundException {
        Class realClazz;
        Class clazz2;
        Intrinsics.checkParameterIsNotNull((Object)clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Object object = clazz;
        if (object instanceof String) {
            clazz2 = Class.forName((String)clazz);
        } else if (object instanceof Class) {
            clazz2 = (Class)clazz;
        } else {
            throw (Throwable)new IllegalArgumentException("Illegal clazz type: " + clazz.getClass());
        }
        Class currClazz = realClazz = clazz2;
        while (true) {
            try {
                Field field;
                Class clazz3 = currClazz;
                if (clazz3 == null) {
                    Intrinsics.throwNpe();
                }
                Field field2 = field = clazz3.getDeclaredField(fieldName);
                Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"field");
                field2.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                if (Intrinsics.areEqual((Object)currClazz, Object.class)) {
                    throw (Throwable)e;
                }
                Class clazz4 = currClazz;
                if (clazz4 == null) {
                    Intrinsics.throwNpe();
                }
                currClazz = clazz4.getSuperclass();
                continue;
            }
            break;
        }
    }

    @NotNull
    public final Method getDeclaredMethodRecursive(@NotNull Object clazz, @NotNull String methodName, Class<?> ... argTypes) throws NoSuchMethodException, ClassNotFoundException {
        Class realClazz;
        Class clazz2;
        Intrinsics.checkParameterIsNotNull((Object)clazz, (String)"clazz");
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        Intrinsics.checkParameterIsNotNull(argTypes, (String)"argTypes");
        Object object = clazz;
        if (object instanceof String) {
            clazz2 = Class.forName((String)clazz);
        } else if (object instanceof Class) {
            clazz2 = (Class)clazz;
        } else {
            throw (Throwable)new IllegalArgumentException("Illegal clazz type: " + clazz.getClass());
        }
        Class currClazz = realClazz = clazz2;
        while (true) {
            try {
                Method method;
                Class clazz3 = currClazz;
                if (clazz3 == null) {
                    Intrinsics.throwNpe();
                }
                Method method2 = method = clazz3.getDeclaredMethod(methodName, Arrays.copyOf(argTypes, argTypes.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
                method2.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                if (Intrinsics.areEqual((Object)currClazz, Object.class)) {
                    throw (Throwable)e;
                }
                Class clazz4 = currClazz;
                if (clazz4 == null) {
                    Intrinsics.throwNpe();
                }
                currClazz = clazz4.getSuperclass();
                continue;
            }
            break;
        }
    }

    private ReflectUtil() {
    }

    static {
        ReflectUtil reflectUtil;
        INSTANCE = reflectUtil = new ReflectUtil();
    }
}

