/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin;

import com.android.build.gradle.AppExtension;
import com.bytedance.rheatrace.common.utils.RheaLog;
import com.bytedance.rheatrace.plugin.RheaContext;
import com.bytedance.rheatrace.plugin.compiling.RheaTraceClassVisitor;
import com.bytedance.rheatrace.plugin.extension.RheaBuildExtension;
import com.bytedance.rheatrace.plugin.extension.TraceCompilation;
import com.bytedance.rheatrace.plugin.extension.TraceRuntime;
import com.bytedance.rheatrace.plugin.internal.CopyMappingTask;
import com.ss.android.ugc.bytex.common.BaseContext;
import com.ss.android.ugc.bytex.common.BaseExtension;
import com.ss.android.ugc.bytex.common.CommonPlugin;
import com.ss.android.ugc.bytex.common.flow.main.Process;
import com.ss.android.ugc.bytex.common.visitor.BaseClassVisitor;
import com.ss.android.ugc.bytex.common.visitor.ClassVisitorChain;
import com.ss.android.ugc.bytex.transformer.TransformEngine;
import com.ss.android.ugc.bytex.transformer.cache.FileData;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J \u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/bytedance/rheatrace/plugin/RheaTracePlugin;", "Lcom/ss/android/ugc/bytex/common/CommonPlugin;", "Lcom/bytedance/rheatrace/plugin/extension/RheaBuildExtension;", "Lcom/bytedance/rheatrace/plugin/RheaContext;", "()V", "TAG", "", "beforeTransform", "", "engine", "Lcom/ss/android/ugc/bytex/transformer/TransformEngine;", "flagForClassReader", "", "process", "Lcom/ss/android/ugc/bytex/common/flow/main/Process;", "getContext", "project", "Lorg/gradle/api/Project;", "android", "Lcom/android/build/gradle/AppExtension;", "extension", "hookTask", "", "hookTransformName", "onApply", "transform", "relativePath", "chain", "Lcom/ss/android/ugc/bytex/common/visitor/ClassVisitorChain;", "traverse", "node", "Lorg/objectweb/asm/tree/ClassNode;", "traverseIncremental", "fileData", "Lcom/ss/android/ugc/bytex/transformer/cache/FileData;", "rhea-gradle-plugin"})
public final class RheaTracePlugin
extends CommonPlugin<RheaBuildExtension, RheaContext> {
    private final String TAG = "RheaTracePlugin";

    protected void onApply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super.onApply(project);
        RheaLog.INSTANCE.i(this.TAG, "Rhea Plugin 2.0", new Object[0]);
        BaseExtension baseExtension = this.extension;
        if (baseExtension == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.plugins.ExtensionAware");
        }
        ((RheaBuildExtension)this.extension).setRuntime((TraceRuntime)((ExtensionAware)baseExtension).getExtensions().create("runtime", TraceRuntime.class, new Object[0]));
        BaseExtension baseExtension2 = this.extension;
        if (baseExtension2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.plugins.ExtensionAware");
        }
        ((RheaBuildExtension)this.extension).setCompilation((TraceCompilation)((ExtensionAware)baseExtension2).getExtensions().create("compilation", TraceCompilation.class, new Object[0]));
        BaseExtension baseExtension3 = this.extension;
        Intrinsics.checkExpressionValueIsNotNull((Object)baseExtension3, (String)"extension");
        CopyMappingTask.INSTANCE.registerTaskSaveMappingToAssets(project, (RheaBuildExtension)baseExtension3);
    }

    @NotNull
    protected RheaContext getContext(@NotNull Project project, @NotNull AppExtension android, @NotNull RheaBuildExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)android, (String)"android");
        Intrinsics.checkParameterIsNotNull((Object)((Object)extension), (String)"extension");
        return new RheaContext(project, android, extension);
    }

    @NotNull
    public String hookTransformName() {
        return "dexBuilder";
    }

    public boolean hookTask() {
        boolean bl;
        Project project = this.project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Gradle gradle = project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        StartParameter startParameter = gradle.getStartParameter();
        Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"project.gradle.startParameter");
        if (StringsKt.contains((CharSequence)startParameter.getTaskNames().toString(), (CharSequence)"release", (boolean)true)) {
            RheaLog.INSTANCE.i(this.TAG, "project is release,Rhea Plugin hook dexBuilder task", new Object[0]);
            bl = true;
        } else {
            RheaLog.INSTANCE.i(this.TAG, "project is debug,Rhea Plugin do not hook dexBuilder task", new Object[0]);
            bl = false;
        }
        return bl;
    }

    public void traverse(@NotNull String relativePath, @NotNull ClassNode node) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        super.traverse(relativePath, node);
        ((RheaContext)this.context).traverse(relativePath, node);
    }

    public void traverseIncremental(@NotNull FileData fileData, @Nullable ClassNode node) {
        Intrinsics.checkParameterIsNotNull((Object)fileData, (String)"fileData");
        super.traverseIncremental(fileData, node);
        if (node != null) {
            RheaContext rheaContext = (RheaContext)this.context;
            String string = fileData.getRelativePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileData.relativePath");
            rheaContext.traverse(string, node);
        }
    }

    public void beforeTransform(@NotNull TransformEngine engine) {
        Intrinsics.checkParameterIsNotNull((Object)engine, (String)"engine");
        super.beforeTransform(engine);
        ((RheaContext)this.context).beforeTransform(engine);
    }

    public boolean transform(@NotNull String relativePath, @NotNull ClassVisitorChain chain) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        BaseContext baseContext = this.context;
        Intrinsics.checkExpressionValueIsNotNull((Object)baseContext, (String)"context");
        chain.connect((BaseClassVisitor)new RheaTraceClassVisitor((RheaContext)baseContext));
        return super.transform(relativePath, chain);
    }

    public int flagForClassReader(@Nullable Process process) {
        return 8;
    }
}

