/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin.compiling;

import com.bytedance.rheatrace.common.retrace.MappingCollector;
import com.bytedance.rheatrace.common.utils.RheaLog;
import com.bytedance.rheatrace.plugin.RheaContext;
import com.bytedance.rheatrace.plugin.compiling.MethodCollector;
import com.bytedance.rheatrace.plugin.compiling.TraceMethod;
import com.bytedance.rheatrace.plugin.compiling.filter.TraceMethodFilter;
import com.bytedance.rheatrace.plugin.internal.RheaFileUtils;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u000201B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000fJ\u0006\u0010*\u001a\u00020(J\u0006\u0010+\u001a\u00020(J\u0010\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020(2\u0006\u0010-\u001a\u00020.H\u0002R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R,\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00170\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R(\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0013\"\u0004\b\u001c\u0010\u0015R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/MethodCollector;", "", "methodId", "Ljava/util/concurrent/atomic/AtomicInteger;", "traceMethodFilter", "Lcom/bytedance/rheatrace/plugin/compiling/filter/TraceMethodFilter;", "collectedMethodMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/bytedance/rheatrace/plugin/compiling/TraceMethod;", "rheaContext", "Lcom/bytedance/rheatrace/plugin/RheaContext;", "(Ljava/util/concurrent/atomic/AtomicInteger;Lcom/bytedance/rheatrace/plugin/compiling/filter/TraceMethodFilter;Ljava/util/concurrent/ConcurrentHashMap;Lcom/bytedance/rheatrace/plugin/RheaContext;)V", "classNodeList", "Ljava/util/ArrayList;", "Lorg/objectweb/asm/tree/ClassNode;", "Lkotlin/collections/ArrayList;", "collectedClassExtendMap", "getCollectedClassExtendMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "setCollectedClassExtendMap", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "collectedClassImplementMap", "", "getCollectedClassImplementMap", "setCollectedClassImplementMap", "collectedIgnoreMethodMap", "getCollectedIgnoreMethodMap", "setCollectedIgnoreMethodMap", "executor", "Ljava/util/concurrent/ExecutorService;", "ignoreCount", "getIgnoreCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setIgnoreCount", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "incrementCount", "getIncrementCount", "setIncrementCount", "collectMethod", "", "classNode", "release", "saveCollectMethod", "saveCollectedMethod", "mappingCollector", "Lcom/bytedance/rheatrace/common/retrace/MappingCollector;", "saveIgnoreCollectedMethod", "CollectMethodTask", "Companion", "rhea-gradle-plugin"})
public final class MethodCollector {
    private final ExecutorService executor;
    private final ArrayList<ClassNode> classNodeList;
    @NotNull
    private ConcurrentHashMap<String, String> collectedClassExtendMap;
    @NotNull
    private ConcurrentHashMap<String, List<String>> collectedClassImplementMap;
    @NotNull
    private ConcurrentHashMap<String, TraceMethod> collectedIgnoreMethodMap;
    @NotNull
    private AtomicInteger ignoreCount;
    @NotNull
    private AtomicInteger incrementCount;
    private final AtomicInteger methodId;
    private final TraceMethodFilter traceMethodFilter;
    private final ConcurrentHashMap<String, TraceMethod> collectedMethodMap;
    private final RheaContext rheaContext;
    private static final String TAG = "MethodCollector";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ConcurrentHashMap<String, String> getCollectedClassExtendMap() {
        return this.collectedClassExtendMap;
    }

    public final void setCollectedClassExtendMap(@NotNull ConcurrentHashMap<String, String> concurrentHashMap) {
        Intrinsics.checkParameterIsNotNull(concurrentHashMap, (String)"<set-?>");
        this.collectedClassExtendMap = concurrentHashMap;
    }

    @NotNull
    public final ConcurrentHashMap<String, List<String>> getCollectedClassImplementMap() {
        return this.collectedClassImplementMap;
    }

    public final void setCollectedClassImplementMap(@NotNull ConcurrentHashMap<String, List<String>> concurrentHashMap) {
        Intrinsics.checkParameterIsNotNull(concurrentHashMap, (String)"<set-?>");
        this.collectedClassImplementMap = concurrentHashMap;
    }

    @NotNull
    public final ConcurrentHashMap<String, TraceMethod> getCollectedIgnoreMethodMap() {
        return this.collectedIgnoreMethodMap;
    }

    public final void setCollectedIgnoreMethodMap(@NotNull ConcurrentHashMap<String, TraceMethod> concurrentHashMap) {
        Intrinsics.checkParameterIsNotNull(concurrentHashMap, (String)"<set-?>");
        this.collectedIgnoreMethodMap = concurrentHashMap;
    }

    @NotNull
    public final AtomicInteger getIgnoreCount() {
        return this.ignoreCount;
    }

    public final void setIgnoreCount(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkParameterIsNotNull((Object)atomicInteger, (String)"<set-?>");
        this.ignoreCount = atomicInteger;
    }

    @NotNull
    public final AtomicInteger getIncrementCount() {
        return this.incrementCount;
    }

    public final void setIncrementCount(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkParameterIsNotNull((Object)atomicInteger, (String)"<set-?>");
        this.incrementCount = atomicInteger;
    }

    public final void saveCollectMethod() throws ExecutionException, InterruptedException {
        RheaLog.INSTANCE.i(TAG, "[saveCollectMethod] start", new Object[0]);
        RheaLog.INSTANCE.i(TAG, "[saveCollectMethod] classNodeList :" + this.classNodeList.size(), new Object[0]);
        List futures = new LinkedList();
        Iterable $this$forEach$iv = this.classNodeList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassNode classNode = (ClassNode)element$iv;
            boolean bl = false;
            try {
                Future<?> future = this.executor.submit(new CollectMethodTask(classNode));
                Intrinsics.checkExpressionValueIsNotNull(future, (String)"executor.submit(CollectMethodTask(classNode))");
                futures.add(future);
            }
            catch (Throwable e) {
                RheaLog.INSTANCE.e(TAG, "[saveCollectMethod] " + e.getMessage(), new Object[0]);
            }
        }
        for (Future future3 : futures) {
            future3.get();
        }
        Future<?> future = this.executor.submit(new Runnable(this){
            final /* synthetic */ MethodCollector this$0;

            public final void run() {
                MethodCollector.access$saveIgnoreCollectedMethod(this.this$0, MethodCollector.access$getTraceMethodFilter$p(this.this$0).getMappingCollector());
            }
            {
                this.this$0 = methodCollector;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(future, (String)"executor.submit { saveIg\u2026ilter.mappingCollector) }");
        futures.add(future);
        Future<?> future2 = this.executor.submit(new Runnable(this){
            final /* synthetic */ MethodCollector this$0;

            public final void run() {
                MethodCollector.access$saveCollectedMethod(this.this$0, MethodCollector.access$getTraceMethodFilter$p(this.this$0).getMappingCollector());
            }
            {
                this.this$0 = methodCollector;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(future2, (String)"executor.submit { saveCo\u2026ilter.mappingCollector) }");
        futures.add(future2);
        for (Future future3 : futures) {
            future3.get();
        }
        futures.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveIgnoreCollectedMethod(MappingCollector mappingCollector) {
        Project project = this.rheaContext.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"rheaContext.project");
        TransformContext transformContext = this.rheaContext.getTransformContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)transformContext, (String)"rheaContext.transformContext");
        String string = transformContext.getVariantName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rheaContext.transformContext.variantName");
        File methodMapFile = new File(RheaFileUtils.INSTANCE.getIgnoreMethodMapFilePath(project, string));
        if (!methodMapFile.getParentFile().exists()) {
            methodMapFile.getParentFile().mkdirs();
        }
        List ignoreMethodList = new ArrayList();
        Collection<TraceMethod> collection = this.collectedIgnoreMethodMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"collectedIgnoreMethodMap.values");
        ignoreMethodList.addAll(collection);
        RheaLog.INSTANCE.i(TAG, "[saveIgnoreCollectedMethod] size:%s path:%s", new Object[]{this.collectedIgnoreMethodMap.size(), methodMapFile.getAbsolutePath()});
        CollectionsKt.sortWith((List)ignoreMethodList, (Comparator)saveIgnoreCollectedMethod.1.INSTANCE);
        PrintWriter pw = null;
        try {
            TransformContext transformContext2 = this.rheaContext.getTransformContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)transformContext2, (String)"rheaContext.transformContext");
            FileOutputStream fileOutputStream = new FileOutputStream(methodMapFile, transformContext2.isIncremental());
            Writer w = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            pw = new PrintWriter(w);
            pw.println("ignore methods:");
            for (TraceMethod traceMethod : ignoreMethodList) {
                TraceMethod traceMethod2;
                if (traceMethod == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                TraceMethod $this$apply = traceMethod2;
                boolean bl3 = false;
                $this$apply.revert(mappingCollector);
                pw.println($this$apply.toIgnoreString());
            }
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            RheaLog.INSTANCE.e(TAG, "write method map Exception:%s", new Object[]{e.getMessage()});
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveCollectedMethod(MappingCollector mappingCollector) {
        Project project = this.rheaContext.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"rheaContext.project");
        TransformContext transformContext = this.rheaContext.getTransformContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)transformContext, (String)"rheaContext.transformContext");
        String string = transformContext.getVariantName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rheaContext.transformContext.variantName");
        File methodMapFile = new File(RheaFileUtils.INSTANCE.getMethodMapFilePath(project, string));
        if (!methodMapFile.getParentFile().exists()) {
            methodMapFile.getParentFile().mkdirs();
        }
        List methodList = new ArrayList();
        TraceMethod extra = TraceMethod.Companion.create(0xFFFFFE, 1, "android.os.Handler", "dispatchMessage", "(Landroid.os.Message;)V");
        ((Map)this.collectedMethodMap).put(extra.getFullMethodName(), extra);
        Collection<TraceMethod> collection = this.collectedMethodMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"collectedMethodMap.values");
        methodList.addAll(collection);
        RheaLog.INSTANCE.i(TAG, "[saveCollectedMethod] size:%s incrementCount:%s path:%s", new Object[]{this.collectedMethodMap.size(), this.incrementCount.get(), methodMapFile.getAbsolutePath()});
        Collections.sort(methodList, saveCollectedMethod.1.INSTANCE);
        PrintWriter pw = null;
        try {
            TransformContext transformContext2 = this.rheaContext.getTransformContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)transformContext2, (String)"rheaContext.transformContext");
            FileOutputStream fileOutputStream = new FileOutputStream(methodMapFile, transformContext2.isIncremental());
            Writer w = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            pw = new PrintWriter(w);
            pw.println("#" + UUID.randomUUID().toString());
            for (TraceMethod traceMethod : methodList) {
                TraceMethod traceMethod2;
                if (traceMethod == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                TraceMethod $this$apply = traceMethod2;
                boolean bl3 = false;
                traceMethod.revert(mappingCollector);
                pw.println(traceMethod.toString());
            }
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            RheaLog.INSTANCE.e(TAG, "write method map Exception:%s", new Object[]{e.getMessage()});
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void collectMethod(@NotNull ClassNode classNode) {
        Intrinsics.checkParameterIsNotNull((Object)classNode, (String)"classNode");
        if (classNode.superName != null) {
            Map map = this.collectedClassExtendMap;
            String string = classNode.name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classNode.name");
            String string2 = classNode.superName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"classNode.superName");
            map.put(string, string2);
        }
        if (classNode.interfaces != null) {
            Map map = this.collectedClassImplementMap;
            String string = classNode.name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classNode.name");
            List list = classNode.interfaces;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"classNode.interfaces");
            map.put(string, list);
        }
        MethodCollector methodCollector = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (methodCollector) {
            boolean bl3 = false;
            bl2 = this.classNodeList.add(classNode);
        }
    }

    public final void release() {
        this.classNodeList.clear();
        this.collectedClassExtendMap.clear();
        this.collectedClassImplementMap.clear();
        this.collectedIgnoreMethodMap.clear();
    }

    public MethodCollector(@NotNull AtomicInteger methodId2, @NotNull TraceMethodFilter traceMethodFilter, @NotNull ConcurrentHashMap<String, TraceMethod> collectedMethodMap, @NotNull RheaContext rheaContext) {
        Intrinsics.checkParameterIsNotNull((Object)methodId2, (String)"methodId");
        Intrinsics.checkParameterIsNotNull((Object)traceMethodFilter, (String)"traceMethodFilter");
        Intrinsics.checkParameterIsNotNull(collectedMethodMap, (String)"collectedMethodMap");
        Intrinsics.checkParameterIsNotNull((Object)((Object)rheaContext), (String)"rheaContext");
        this.methodId = methodId2;
        this.traceMethodFilter = traceMethodFilter;
        this.collectedMethodMap = collectedMethodMap;
        this.rheaContext = rheaContext;
        ExecutorService executorService = Executors.newFixedThreadPool(16);
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newFixedThreadPool(16)");
        this.executor = executorService;
        MethodCollector methodCollector = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        methodCollector.classNodeList = arrayList;
        this.collectedClassExtendMap = new ConcurrentHashMap();
        this.collectedClassImplementMap = new ConcurrentHashMap();
        this.collectedIgnoreMethodMap = new ConcurrentHashMap();
        this.ignoreCount = new AtomicInteger();
        this.incrementCount = new AtomicInteger();
    }

    public static final /* synthetic */ void access$saveIgnoreCollectedMethod(MethodCollector $this, MappingCollector mappingCollector) {
        $this.saveIgnoreCollectedMethod(mappingCollector);
    }

    public static final /* synthetic */ void access$saveCollectedMethod(MethodCollector $this, MappingCollector mappingCollector) {
        $this.saveCollectedMethod(mappingCollector);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/MethodCollector$CollectMethodTask;", "Ljava/lang/Runnable;", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "(Lcom/bytedance/rheatrace/plugin/compiling/MethodCollector;Lorg/objectweb/asm/tree/ClassNode;)V", "getClassNode", "()Lorg/objectweb/asm/tree/ClassNode;", "setClassNode", "(Lorg/objectweb/asm/tree/ClassNode;)V", "run", "", "rhea-gradle-plugin"})
    public final class CollectMethodTask
    implements Runnable {
        @NotNull
        private ClassNode classNode;

        @Override
        public void run() {
            try {
                List list = this.classNode.methods;
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"classNode.methods");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MethodNode it = (MethodNode)element$iv;
                    boolean bl = false;
                    int n = it.access;
                    String string = this.classNode.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classNode.name");
                    String string2 = it.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.name");
                    TraceMethod traceMethod = TraceMethod.Companion.create(0, n, string, string2, it.desc);
                    TraceMethodFilter traceMethodFilter = MethodCollector.this.traceMethodFilter;
                    MethodNode methodNode = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)methodNode, (String)"it");
                    boolean needFilter = traceMethodFilter.needFilter(methodNode, traceMethod, this.classNode);
                    if (needFilter) {
                        if (MethodCollector.this.getCollectedIgnoreMethodMap().containsKey(traceMethod.getFullMethodName())) continue;
                        MethodCollector.this.getIgnoreCount().incrementAndGet();
                        ((Map)MethodCollector.this.getCollectedIgnoreMethodMap()).put(traceMethod.getFullMethodName(), traceMethod);
                        continue;
                    }
                    if (MethodCollector.this.collectedMethodMap.containsKey(traceMethod.getFullMethodName())) continue;
                    traceMethod.setId(MethodCollector.this.methodId.incrementAndGet());
                    MethodCollector.this.getIncrementCount().incrementAndGet();
                    ((Map)MethodCollector.this.collectedMethodMap).put(traceMethod.getFullMethodName(), traceMethod);
                }
            }
            catch (Exception e) {
                RheaLog.INSTANCE.e(MethodCollector.TAG, "[saveCollectMethod] error:" + e.getMessage(), new Object[0]);
            }
        }

        @NotNull
        public final ClassNode getClassNode() {
            return this.classNode;
        }

        public final void setClassNode(@NotNull ClassNode classNode) {
            Intrinsics.checkParameterIsNotNull((Object)classNode, (String)"<set-?>");
            this.classNode = classNode;
        }

        public CollectMethodTask(ClassNode classNode) {
            Intrinsics.checkParameterIsNotNull((Object)classNode, (String)"classNode");
            this.classNode = classNode;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/MethodCollector$Companion;", "", "()V", "TAG", "", "rhea-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

