/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin.compiling;

import com.android.build.gradle.api.BaseVariant;
import com.bytedance.rheatrace.common.retrace.MappingCollector;
import com.bytedance.rheatrace.common.retrace.MappingProcessor;
import com.bytedance.rheatrace.common.retrace.MappingReader;
import com.bytedance.rheatrace.common.utils.RheaLog;
import com.bytedance.rheatrace.plugin.RheaContext;
import com.bytedance.rheatrace.plugin.compiling.TraceMethod;
import com.google.common.base.Joiner;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import java.io.Closeable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ&\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0002J$\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\t2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/ParseMappingTask;", "Ljava/lang/Runnable;", "rheaContext", "Lcom/bytedance/rheatrace/plugin/RheaContext;", "methodId", "Ljava/util/concurrent/atomic/AtomicInteger;", "applyMethodMappingFilePath", "", "mappingCollector", "Lcom/bytedance/rheatrace/common/retrace/MappingCollector;", "collectedMethodMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/bytedance/rheatrace/plugin/compiling/TraceMethod;", "(Lcom/bytedance/rheatrace/plugin/RheaContext;Ljava/util/concurrent/atomic/AtomicInteger;Ljava/lang/String;Lcom/bytedance/rheatrace/common/retrace/MappingCollector;Ljava/util/concurrent/ConcurrentHashMap;)V", "getAppliedMethodMapping", "", "getMappingDir", "retraceMethodMap", "processor", "methodMap", "run", "Companion", "rhea-gradle-plugin"})
public final class ParseMappingTask
implements Runnable {
    private final RheaContext rheaContext;
    private final AtomicInteger methodId;
    private final String applyMethodMappingFilePath;
    private final MappingCollector mappingCollector;
    private final ConcurrentHashMap<String, TraceMethod> collectedMethodMap;
    private static final String TAG = "ParseMappingTask";
    public static final Companion Companion = new Companion(null);

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        File mappingFile = new File(this.getMappingDir(), "mapping.txt");
        if (mappingFile.isFile()) {
            MappingReader mappingReader = new MappingReader(mappingFile);
            mappingReader.read((MappingProcessor)this.mappingCollector);
        }
        this.getAppliedMethodMapping(this.applyMethodMappingFilePath, this.collectedMethodMap);
        this.retraceMethodMap(this.mappingCollector, this.collectedMethodMap);
        long duration = System.currentTimeMillis() - start;
        RheaLog.INSTANCE.i(TAG, "[ParseMappingTask#run] cost:%sms,  collect %s method from %s", new Object[]{duration, this.collectedMethodMap.size(), this.applyMethodMappingFilePath});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getAppliedMethodMapping(String applyMethodMappingFilePath, ConcurrentHashMap<String, TraceMethod> collectedMethodMap) {
        if (applyMethodMappingFilePath == null) {
            RheaLog.INSTANCE.w(TAG, "[applyMethodMappingFilePath] is null!", new Object[0]);
            return;
        }
        File applyMethodMappingFile = new File(applyMethodMappingFilePath);
        if (!applyMethodMappingFile.exists()) {
            RheaLog.INSTANCE.w(TAG, "[applyMethodMappingFile] is not existed, " + applyMethodMappingFile.getAbsoluteFile(), new Object[0]);
        }
        try {
            Closeable closeable = new Scanner(applyMethodMappingFile, "UTF-8");
            boolean bl = false;
            Throwable throwable = null;
            try {
                Scanner fileReader = (Scanner)closeable;
                boolean bl2 = false;
                while (fileReader.hasNext()) {
                    String nextLine = fileReader.nextLine();
                    if (nextLine == null) continue;
                    CharSequence charSequence = nextLine;
                    boolean bl3 = false;
                    if (charSequence.length() == 0) continue;
                    charSequence = nextLine;
                    bl3 = false;
                    nextLine = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
                    if (StringsKt.startsWith$default((String)nextLine, (String)"#", (boolean)false, (int)2, null)) {
                        RheaLog.INSTANCE.i("[getMethodFromKeepMethod] comment %s", nextLine, new Object[0]);
                        continue;
                    }
                    List fields = StringsKt.split$default((CharSequence)nextLine, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                    TraceMethod traceMethod = new TraceMethod();
                    traceMethod.setId(Integer.parseInt((String)fields.get(0)));
                    traceMethod.setAccessFlag(Integer.parseInt((String)fields.get(1)));
                    List methodField = StringsKt.split$default((CharSequence)((CharSequence)fields.get(2)), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
                    traceMethod.setClassName(StringsKt.replace$default((String)((String)methodField.get(0)), (String)"/", (String)".", (boolean)false, (int)4, null));
                    traceMethod.setMethodName((String)methodField.get(1));
                    if (methodField.size() > 2) {
                        traceMethod.setDesc(StringsKt.replace$default((String)((String)methodField.get(2)), (String)"/", (String)".", (boolean)false, (int)4, null));
                    }
                    ((Map)collectedMethodMap).put(traceMethod.getFullMethodName(), traceMethod);
                    if (this.methodId.get() >= traceMethod.getId() || traceMethod.getId() == 0xFFFFFE) continue;
                    this.methodId.set(traceMethod.getId());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            RheaLog.INSTANCE.w(TAG, "Failed to parse applied method mapping file", new Object[0]);
        }
    }

    private final void retraceMethodMap(MappingCollector processor, ConcurrentHashMap<String, TraceMethod> methodMap) {
        HashMap retraceMethodMap = new HashMap(methodMap.size());
        for (TraceMethod traceMethod : methodMap.values()) {
            traceMethod.proguard(processor);
            Map map = retraceMethodMap;
            String string = traceMethod.getFullMethodName();
            TraceMethod traceMethod2 = traceMethod;
            Intrinsics.checkExpressionValueIsNotNull((Object)traceMethod2, (String)"traceMethod");
            map.put(string, traceMethod2);
        }
        methodMap.clear();
        methodMap.putAll(retraceMethodMap);
        retraceMethodMap.clear();
    }

    private final String getMappingDir() {
        String string;
        TransformContext transformContext = this.rheaContext.getTransformContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)transformContext, (String)"rheaContext.transformContext");
        BaseVariant baseVariant = transformContext.getVariant();
        Intrinsics.checkExpressionValueIsNotNull((Object)baseVariant, (String)"rheaContext.transformContext.variant");
        if (baseVariant.getBuildType().isMinifyEnabled()) {
            TransformContext transformContext2 = this.rheaContext.getTransformContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)transformContext2, (String)"rheaContext.transformContext");
            BaseVariant baseVariant2 = transformContext2.getVariant();
            Intrinsics.checkExpressionValueIsNotNull((Object)baseVariant2, (String)"rheaContext.transformContext.variant");
            File file = baseVariant2.getMappingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"rheaContext.transformContext.variant.mappingFile");
            String string2 = file.getParent();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"rheaContext.transformCon\u2026ariant.mappingFile.parent");
        } else {
            Joiner joiner = Joiner.on((char)File.separatorChar);
            Project project = this.rheaContext.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"rheaContext.project");
            File file = project.getBuildDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"rheaContext.project.buildDir");
            String string3 = file.getAbsolutePath();
            Object[] objectArray = new Object[2];
            objectArray[0] = "mapping";
            TransformContext transformContext3 = this.rheaContext.getTransformContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)transformContext3, (String)"rheaContext.transformContext");
            objectArray[1] = transformContext3.getVariantName();
            String string4 = joiner.join((Object)string3, (Object)"outputs", objectArray);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"Joiner.on(File.separator\u2026variantName\n            )");
        }
        return string;
    }

    public ParseMappingTask(@NotNull RheaContext rheaContext, @NotNull AtomicInteger methodId2, @Nullable String applyMethodMappingFilePath, @NotNull MappingCollector mappingCollector, @NotNull ConcurrentHashMap<String, TraceMethod> collectedMethodMap) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)rheaContext), (String)"rheaContext");
        Intrinsics.checkParameterIsNotNull((Object)methodId2, (String)"methodId");
        Intrinsics.checkParameterIsNotNull((Object)mappingCollector, (String)"mappingCollector");
        Intrinsics.checkParameterIsNotNull(collectedMethodMap, (String)"collectedMethodMap");
        this.rheaContext = rheaContext;
        this.methodId = methodId2;
        this.applyMethodMappingFilePath = applyMethodMappingFilePath;
        this.mappingCollector = mappingCollector;
        this.collectedMethodMap = collectedMethodMap;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/ParseMappingTask$Companion;", "", "()V", "TAG", "", "rhea-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

