/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin.compiling.filter;

import com.bytedance.rheatrace.common.retrace.MappingCollector;
import com.bytedance.rheatrace.plugin.compiling.TraceMethod;
import com.bytedance.rheatrace.plugin.compiling.filter.TraceMethodFilter;
import com.bytedance.rheatrace.plugin.internal.RheaConstants;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/filter/DefaultTraceMethodFilter;", "Lcom/bytedance/rheatrace/plugin/compiling/filter/TraceMethodFilter;", "mappingCollector", "Lcom/bytedance/rheatrace/common/retrace/MappingCollector;", "(Lcom/bytedance/rheatrace/common/retrace/MappingCollector;)V", "onClassNeedFilter", "", "originFullMethod", "", "onMethodNeedFilter", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "traceMethod", "Lcom/bytedance/rheatrace/plugin/compiling/TraceMethod;", "Companion", "rhea-gradle-plugin"})
public abstract class DefaultTraceMethodFilter
extends TraceMethodFilter {
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean onMethodNeedFilter(@NotNull MethodNode methodNode, @NotNull TraceMethod traceMethod, @NotNull String originFullMethod) {
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        Intrinsics.checkParameterIsNotNull((Object)traceMethod, (String)"traceMethod");
        Intrinsics.checkParameterIsNotNull((Object)originFullMethod, (String)"originFullMethod");
        return DefaultTraceMethodFilter.Companion.isGetOrSetMethod(methodNode) || DefaultTraceMethodFilter.Companion.isSingleMethod(methodNode) || DefaultTraceMethodFilter.Companion.isEmptyMethod(methodNode);
    }

    @Override
    public boolean onClassNeedFilter(@NotNull String originFullMethod) {
        Intrinsics.checkParameterIsNotNull((Object)originFullMethod, (String)"originFullMethod");
        for (String unTraceCls : RheaConstants.INSTANCE.getUN_TRACE_CLASS()) {
            if (!StringsKt.contains$default((CharSequence)originFullMethod, (CharSequence)unTraceCls, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    public DefaultTraceMethodFilter(@NotNull MappingCollector mappingCollector) {
        Intrinsics.checkParameterIsNotNull((Object)mappingCollector, (String)"mappingCollector");
        super(mappingCollector);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/filter/DefaultTraceMethodFilter$Companion;", "", "()V", "isEmptyMethod", "", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "isGetOrSetMethod", "node", "isSingleMethod", "rhea-gradle-plugin"})
    public static final class Companion {
        private final boolean isGetOrSetMethod(MethodNode node) {
            int ignoreCount = 0;
            ListIterator listIterator = node.instructions.iterator();
            Intrinsics.checkExpressionValueIsNotNull((Object)listIterator, (String)"node.instructions.iterator()");
            ListIterator iterator = listIterator;
            while (iterator.hasNext()) {
                AbstractInsnNode insnNode;
                AbstractInsnNode abstractInsnNode = insnNode = (AbstractInsnNode)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"insnNode");
                int opcode = abstractInsnNode.getOpcode();
                if (-1 == opcode || opcode == 180 || opcode == 178 || opcode == 1 || opcode == 2 || opcode == 177 || opcode == 176 || opcode == 175 || opcode == 174 || opcode == 173 || opcode == 172 || opcode == 181 || opcode == 179 || opcode == 3 || opcode == 4 || opcode <= 53) continue;
                if (Intrinsics.areEqual((Object)"<init>", (Object)node.name) && opcode == 183) {
                    if (++ignoreCount <= 1) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private final boolean isSingleMethod(MethodNode methodNode) {
            ListIterator listIterator = methodNode.instructions.iterator();
            Intrinsics.checkExpressionValueIsNotNull((Object)listIterator, (String)"methodNode.instructions.iterator()");
            ListIterator iterator = listIterator;
            while (iterator.hasNext()) {
                AbstractInsnNode insnNode;
                AbstractInsnNode abstractInsnNode = insnNode = (AbstractInsnNode)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"insnNode");
                int opcode = abstractInsnNode.getOpcode();
                if (-1 == opcode || 182 > opcode || opcode > 186) continue;
                return false;
            }
            return true;
        }

        private final boolean isEmptyMethod(MethodNode methodNode) {
            ListIterator listIterator = methodNode.instructions.iterator();
            Intrinsics.checkExpressionValueIsNotNull((Object)listIterator, (String)"methodNode.instructions.iterator()");
            ListIterator iterator = listIterator;
            while (iterator.hasNext()) {
                AbstractInsnNode insnNode;
                AbstractInsnNode abstractInsnNode = insnNode = (AbstractInsnNode)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"insnNode");
                int opcode = abstractInsnNode.getOpcode();
                if (-1 == opcode) continue;
                return false;
            }
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

