/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin.compiling;

import com.bytedance.rheatrace.common.retrace.MappingCollector;
import com.bytedance.rheatrace.common.retrace.MappingProcessor;
import com.bytedance.rheatrace.common.retrace.MappingReader;
import com.bytedance.rheatrace.common.utils.RheaLog;
import com.bytedance.rheatrace.plugin.compiling.TraceMethod;
import java.io.Closeable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ&\u0010\r\u001a\u00020\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nH\u0002J$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/ParseMappingTask;", "Ljava/lang/Runnable;", "methodId", "Ljava/util/concurrent/atomic/AtomicInteger;", "methodMappingDir", "", "applyMethodMappingFilePath", "mappingCollector", "Lcom/bytedance/rheatrace/common/retrace/MappingCollector;", "collectedMethodMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/bytedance/rheatrace/plugin/compiling/TraceMethod;", "(Ljava/util/concurrent/atomic/AtomicInteger;Ljava/lang/String;Ljava/lang/String;Lcom/bytedance/rheatrace/common/retrace/MappingCollector;Ljava/util/concurrent/ConcurrentHashMap;)V", "getAppliedMethodMapping", "", "retraceMethodMap", "processor", "methodMap", "run", "Companion", "rhea-gradle-plugin"})
public final class ParseMappingTask
implements Runnable {
    private final AtomicInteger methodId;
    private final String methodMappingDir;
    private final String applyMethodMappingFilePath;
    private final MappingCollector mappingCollector;
    private final ConcurrentHashMap<String, TraceMethod> collectedMethodMap;
    private static final String TAG = "ParseMappingTask";
    public static final Companion Companion = new Companion(null);

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        File mappingFile = new File(this.methodMappingDir, "mapping.txt");
        if (mappingFile.isFile()) {
            MappingReader mappingReader = new MappingReader(mappingFile);
            mappingReader.read((MappingProcessor)this.mappingCollector);
        }
        this.getAppliedMethodMapping(this.applyMethodMappingFilePath, this.collectedMethodMap);
        this.retraceMethodMap(this.mappingCollector, this.collectedMethodMap);
        long duration = System.currentTimeMillis() - start;
        RheaLog.INSTANCE.i(TAG, "[ParseMappingTask#run] cost:%sms,  collect %s method from %s", new Object[]{duration, this.collectedMethodMap.size(), this.applyMethodMappingFilePath});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getAppliedMethodMapping(String applyMethodMappingFilePath, ConcurrentHashMap<String, TraceMethod> collectedMethodMap) {
        if (applyMethodMappingFilePath == null) {
            RheaLog.INSTANCE.w(TAG, "[applyMethodMappingFilePath] is null!", new Object[0]);
            return;
        }
        File applyMethodMappingFile = new File(applyMethodMappingFilePath);
        if (!applyMethodMappingFile.exists()) {
            RheaLog.INSTANCE.w(TAG, "[applyMethodMappingFile] is not existed, " + applyMethodMappingFile.getAbsoluteFile(), new Object[0]);
        }
        try {
            Closeable closeable = new Scanner(applyMethodMappingFile, "UTF-8");
            boolean bl = false;
            Throwable throwable = null;
            try {
                Scanner fileReader = (Scanner)closeable;
                boolean bl2 = false;
                while (fileReader.hasNext()) {
                    String nextLine = fileReader.nextLine();
                    if (nextLine == null) continue;
                    CharSequence charSequence = nextLine;
                    boolean bl3 = false;
                    if (charSequence.length() == 0) continue;
                    charSequence = nextLine;
                    bl3 = false;
                    nextLine = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
                    if (StringsKt.startsWith$default((String)nextLine, (String)"#", (boolean)false, (int)2, null)) {
                        RheaLog.INSTANCE.i("[getMethodFromKeepMethod] comment %s", nextLine, new Object[0]);
                        continue;
                    }
                    List fields = StringsKt.split$default((CharSequence)nextLine, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
                    TraceMethod traceMethod = new TraceMethod();
                    traceMethod.setId(Integer.parseInt((String)fields.get(0)));
                    traceMethod.setAccessFlag(Integer.parseInt((String)fields.get(1)));
                    List methodField = StringsKt.split$default((CharSequence)((CharSequence)fields.get(2)), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
                    traceMethod.setClassName(StringsKt.replace$default((String)((String)methodField.get(0)), (String)"/", (String)".", (boolean)false, (int)4, null));
                    traceMethod.setMethodName((String)methodField.get(1));
                    if (methodField.size() > 2) {
                        traceMethod.setDesc(StringsKt.replace$default((String)((String)methodField.get(2)), (String)"/", (String)".", (boolean)false, (int)4, null));
                    }
                    ((Map)collectedMethodMap).put(traceMethod.getFullMethodName(), traceMethod);
                    if (this.methodId.get() >= traceMethod.getId() || traceMethod.getId() == 0xFFFFFE) continue;
                    this.methodId.set(traceMethod.getId());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable e) {
            RheaLog.INSTANCE.w(TAG, "Failed to parse applied method mapping file", new Object[0]);
        }
    }

    private final void retraceMethodMap(MappingCollector processor, ConcurrentHashMap<String, TraceMethod> methodMap) {
        HashMap retraceMethodMap = new HashMap(methodMap.size());
        for (TraceMethod traceMethod : methodMap.values()) {
            traceMethod.proguard(processor);
            Map map = retraceMethodMap;
            String string = traceMethod.getFullMethodName();
            TraceMethod traceMethod2 = traceMethod;
            Intrinsics.checkExpressionValueIsNotNull((Object)traceMethod2, (String)"traceMethod");
            map.put(string, traceMethod2);
        }
        methodMap.clear();
        methodMap.putAll(retraceMethodMap);
        retraceMethodMap.clear();
    }

    public ParseMappingTask(@NotNull AtomicInteger methodId, @NotNull String methodMappingDir, @Nullable String applyMethodMappingFilePath, @NotNull MappingCollector mappingCollector, @NotNull ConcurrentHashMap<String, TraceMethod> collectedMethodMap) {
        Intrinsics.checkParameterIsNotNull((Object)methodId, (String)"methodId");
        Intrinsics.checkParameterIsNotNull((Object)methodMappingDir, (String)"methodMappingDir");
        Intrinsics.checkParameterIsNotNull((Object)mappingCollector, (String)"mappingCollector");
        Intrinsics.checkParameterIsNotNull(collectedMethodMap, (String)"collectedMethodMap");
        this.methodId = methodId;
        this.methodMappingDir = methodMappingDir;
        this.applyMethodMappingFilePath = applyMethodMappingFilePath;
        this.mappingCollector = mappingCollector;
        this.collectedMethodMap = collectedMethodMap;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/ParseMappingTask$Companion;", "", "()V", "TAG", "", "rhea-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

