/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin.compiling;

import com.android.build.api.transform.Status;
import com.bytedance.rheatrace.common.retrace.MappingCollector;
import com.bytedance.rheatrace.common.utils.RheaLog;
import com.bytedance.rheatrace.plugin.compiling.CollectDirectoryInputTask;
import com.bytedance.rheatrace.plugin.compiling.CollectJarInputTask;
import com.bytedance.rheatrace.plugin.compiling.MethodCollector;
import com.bytedance.rheatrace.plugin.compiling.MethodTracer;
import com.bytedance.rheatrace.plugin.compiling.ParseMappingTask;
import com.bytedance.rheatrace.plugin.compiling.TraceMethod;
import com.bytedance.rheatrace.plugin.compiling.filter.RheaTraceMethodFilter;
import com.bytedance.rheatrace.plugin.extension.TraceCompilation;
import com.bytedance.rheatrace.plugin.internal.RheaFileUtils;
import com.bytedance.rheatrace.precise.PreciseInstrumentationContext;
import com.bytedance.rheatrace.precise.extension.PreciseInstrumentationExtension;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"BA\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0090\u0001\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112&\u0010\u0019\u001a\"\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001a2\u001a\u0010\u001b\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/TraceWeaver;", "", "applicationName", "", "methodMappingDir", "methodMapFilePath", "ignoreMethodMapFilePath", "traceCompilation", "Lcom/bytedance/rheatrace/plugin/extension/TraceCompilation;", "variantName", "project", "Lorg/gradle/api/Project;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/bytedance/rheatrace/plugin/extension/TraceCompilation;Ljava/lang/String;Lorg/gradle/api/Project;)V", "doTransform", "", "classInputs", "", "Ljava/io/File;", "changedFiles", "", "Lcom/android/build/api/transform/Status;", "inputToOutput", "isIncremental", "", "traceClassOutputDirectory", "legacyReplaceChangedFile", "Lkotlin/Function2;", "legacyReplaceFile", "initMethodId", "Ljava/util/concurrent/atomic/AtomicInteger;", "intPreciseInstContext", "Lcom/bytedance/rheatrace/precise/PreciseInstrumentationContext;", "mappingCollector", "Lcom/bytedance/rheatrace/common/retrace/MappingCollector;", "Companion", "rhea-gradle-plugin"})
public final class TraceWeaver {
    private final String applicationName;
    private final String methodMappingDir;
    private final String methodMapFilePath;
    private final String ignoreMethodMapFilePath;
    private final TraceCompilation traceCompilation;
    private final String variantName;
    private final Project project;
    private static final String TAG = "TraceWeaver";
    public static final Companion Companion = new Companion(null);

    public final void doTransform(@NotNull Collection<? extends File> classInputs, @NotNull Map<File, ? extends Status> changedFiles, @NotNull Map<File, ? extends File> inputToOutput, boolean isIncremental, @NotNull File traceClassOutputDirectory, @Nullable Function2<? super File, ? super Map<File, ? extends Status>, ? extends Object> legacyReplaceChangedFile2, @Nullable Function2<? super File, ? super File, ? extends Object> legacyReplaceFile2) {
        Intrinsics.checkParameterIsNotNull(classInputs, (String)"classInputs");
        Intrinsics.checkParameterIsNotNull(changedFiles, (String)"changedFiles");
        Intrinsics.checkParameterIsNotNull(inputToOutput, (String)"inputToOutput");
        Intrinsics.checkParameterIsNotNull((Object)traceClassOutputDirectory, (String)"traceClassOutputDirectory");
        RheaLog.INSTANCE.i(TAG, "isIncremental ===> " + isIncremental, new Object[0]);
        ExecutorService executorService = Executors.newFixedThreadPool(16);
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newFixedThreadPool(16)");
        ExecutorService executor = executorService;
        AtomicInteger methodId = this.initMethodId(isIncremental);
        ConcurrentHashMap<String, TraceMethod> collectedMethodMap = new ConcurrentHashMap<String, TraceMethod>();
        ConcurrentHashMap dirInputOutMap = new ConcurrentHashMap();
        ConcurrentHashMap jarInputOutMap = new ConcurrentHashMap();
        MappingCollector mappingCollector = new MappingCollector();
        PreciseInstrumentationContext preciseInstContext = this.intPreciseInstContext(mappingCollector);
        TraceCompilation traceCompilation = this.traceCompilation;
        RheaTraceMethodFilter traceMethodFilter = new RheaTraceMethodFilter(traceCompilation != null ? traceCompilation.getTraceFilterFilePath() : null, mappingCollector);
        long start = System.currentTimeMillis();
        LinkedList futures = new LinkedList();
        TraceCompilation traceCompilation2 = this.traceCompilation;
        ParseMappingTask mappingTask = new ParseMappingTask(methodId, this.methodMappingDir, traceCompilation2 != null ? traceCompilation2.getApplyMethodMappingFilePath() : null, mappingCollector, collectedMethodMap);
        futures.add(executor.submit(mappingTask));
        for (File file : classInputs) {
            if (file.isDirectory()) {
                CollectDirectoryInputTask collectDirectoryTask = new CollectDirectoryInputTask(file, changedFiles, inputToOutput, isIncremental, traceClassOutputDirectory, legacyReplaceChangedFile2, legacyReplaceFile2, dirInputOutMap);
                futures.add(executor.submit(collectDirectoryTask));
                continue;
            }
            Status status = Status.CHANGED;
            CollectJarInputTask collectJarInputTask = new CollectJarInputTask(file, status, inputToOutput, isIncremental, traceClassOutputDirectory, legacyReplaceFile2, jarInputOutMap);
            futures.add(executor.submit(collectJarInputTask));
        }
        for (Future future : futures) {
            future.get();
        }
        futures.clear();
        long l = System.currentTimeMillis() - start;
        RheaLog.INSTANCE.i(TAG, "[doTransform] Step(1)[Parse]... cost:%sms", new Object[]{l});
        start = System.currentTimeMillis();
        MethodCollector methodCollector = new MethodCollector(methodId, executor, this.methodMapFilePath, this.ignoreMethodMapFilePath, traceMethodFilter, collectedMethodMap, isIncremental, preciseInstContext);
        ConcurrentHashMap.KeySetView keySetView = (ConcurrentHashMap.KeySetView)dirInputOutMap.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)keySetView, (String)"dirInputOutMap.keys");
        Set set = keySetView;
        ConcurrentHashMap.KeySetView keySetView2 = (ConcurrentHashMap.KeySetView)jarInputOutMap.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)keySetView2, (String)"jarInputOutMap.keys");
        methodCollector.collectClassNode(set, keySetView2);
        methodCollector.saveCollectMethod();
        l = System.currentTimeMillis() - start;
        RheaLog.INSTANCE.i(TAG, "[doTransform] Step(2)[Collection]... cost:%sms", new Object[]{l});
        start = System.currentTimeMillis();
        TraceCompilation traceCompilation3 = this.traceCompilation;
        if (traceCompilation3 == null) {
            Intrinsics.throwNpe();
        }
        MethodTracer tracer = new MethodTracer(executor, mappingCollector, collectedMethodMap, traceCompilation3, this.applicationName, traceMethodFilter);
        tracer.trace(dirInputOutMap, jarInputOutMap);
        l = System.currentTimeMillis() - start;
        RheaLog.INSTANCE.i(TAG, "[doTransform] Step(3)[Trace]... cost:%sms", new Object[]{l});
        collectedMethodMap.clear();
    }

    private final AtomicInteger initMethodId(boolean isIncremental) {
        File methodCollectMethodFile = new File(RheaFileUtils.INSTANCE.getMethodMapFilePath(this.project, this.variantName));
        if (methodCollectMethodFile.exists() && isIncremental) {
            return new AtomicInteger(RheaFileUtils.INSTANCE.getFileLineCount(methodCollectMethodFile));
        }
        return new AtomicInteger();
    }

    private final PreciseInstrumentationContext intPreciseInstContext(MappingCollector mappingCollector) {
        PreciseInstrumentationExtension preciseInstrumentationExtension = new PreciseInstrumentationExtension();
        TraceCompilation traceCompilation = this.traceCompilation;
        String string = traceCompilation != null ? traceCompilation.getTraceFilterFilePath() : null;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        preciseInstrumentationExtension.setTraceFilter(string);
        PreciseInstrumentationContext context = new PreciseInstrumentationContext(this.project, mappingCollector, preciseInstrumentationExtension);
        context.init();
        return context;
    }

    public TraceWeaver(@Nullable String applicationName, @NotNull String methodMappingDir, @NotNull String methodMapFilePath, @NotNull String ignoreMethodMapFilePath, @Nullable TraceCompilation traceCompilation, @NotNull String variantName, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)methodMappingDir, (String)"methodMappingDir");
        Intrinsics.checkParameterIsNotNull((Object)methodMapFilePath, (String)"methodMapFilePath");
        Intrinsics.checkParameterIsNotNull((Object)ignoreMethodMapFilePath, (String)"ignoreMethodMapFilePath");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.applicationName = applicationName;
        this.methodMappingDir = methodMappingDir;
        this.methodMapFilePath = methodMapFilePath;
        this.ignoreMethodMapFilePath = ignoreMethodMapFilePath;
        this.traceCompilation = traceCompilation;
        this.variantName = variantName;
        this.project = project;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/TraceWeaver$Companion;", "", "()V", "TAG", "", "rhea-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

