/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin.task;

import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.internal.tasks.DexArchiveBuilderTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.bytedance.rheatrace.common.utils.RheaLog;
import com.bytedance.rheatrace.plugin.extension.RheaBuildExtension;
import com.bytedance.rheatrace.plugin.task.RheaTraceTask;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/bytedance/rheatrace/plugin/task/RheaTraceTasksManager;", "", "()V", "TAG", "", "createRheaTraceTask", "", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/gradle/api/ApplicationVariant;", "extension", "Lcom/bytedance/rheatrace/plugin/extension/RheaBuildExtension;", "rhea-gradle-plugin"})
public final class RheaTraceTasksManager {
    private static final String TAG = "RheaTraceTask";
    public static final RheaTraceTasksManager INSTANCE;

    public final void createRheaTraceTask(@NotNull Project project, @NotNull ApplicationVariant variant, @NotNull RheaBuildExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        String variantName = variant.getName();
        RheaTraceTask.CreationAction action = new RheaTraceTask.CreationAction(project, variant, extension);
        TaskContainer taskContainer = project.getTasks();
        StringBuilder stringBuilder = new StringBuilder().append("rhea");
        String string = variantName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantName");
        TaskProvider traceTaskProvider = taskContainer.register(stringBuilder.append(StringsKt.capitalize((String)string)).append("Trace").toString(), RheaTraceTask.class, (Action)action);
        String minifyTask = "minify" + StringsKt.capitalize((String)variantName) + "WithProguard";
        try {
            TaskProvider taskProvider = project.getTasks().named(minifyTask);
            TaskProvider taskProvider2 = traceTaskProvider;
            Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider2, (String)"traceTaskProvider");
            TaskProvider[] taskProviderArray = new TaskProvider[1];
            TaskProvider taskProvider3 = taskProvider;
            Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider3, (String)"taskProvider");
            taskProviderArray[0] = taskProvider3;
            TaskFactoryUtils.dependsOn((TaskProvider)taskProvider2, (TaskProvider[])taskProviderArray);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        String dexBuilderTaskName = "dexBuilder" + StringsKt.capitalize((String)variantName);
        try {
            TaskProvider dexBuilderProvider = project.getTasks().named(dexBuilderTaskName);
            dexBuilderProvider.configure((Action)new Action<Task>(traceTaskProvider){
                final /* synthetic */ TaskProvider $traceTaskProvider;

                public final void execute(@NotNull Task task) {
                    Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
                    ((RheaTraceTask)((Object)this.$traceTaskProvider.get())).wired((DexArchiveBuilderTask)task);
                }
                {
                    this.$traceTaskProvider = taskProvider;
                }
            });
        }
        catch (Throwable e) {
            RheaLog.INSTANCE.e(TAG, "Do not find '" + dexBuilderTaskName + "' task. Inject rhea trace task failed.", new Object[0]);
        }
    }

    private RheaTraceTasksManager() {
    }

    static {
        RheaTraceTasksManager rheaTraceTasksManager;
        INSTANCE = rheaTraceTasksManager = new RheaTraceTasksManager();
    }
}

