/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin.transform;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.bytedance.rheatrace.common.utils.AGPCompat;
import com.bytedance.rheatrace.common.utils.ManifestUtil;
import com.bytedance.rheatrace.common.utils.RheaLog;
import com.bytedance.rheatrace.plugin.extension.RheaBuildExtension;
import com.bytedance.rheatrace.plugin.extension.TraceCompilation;
import com.bytedance.rheatrace.plugin.internal.RheaFileUtils;
import com.bytedance.rheatrace.plugin.transform.TransformArgs;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0016\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0016J\u0010\u0010\u0016\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00180\u0017H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H&R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010\u0007\u001a\"\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bj\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/bytedance/rheatrace/plugin/transform/RheaBaseTransform;", "Lcom/android/build/api/transform/Transform;", "project", "Lorg/gradle/api/Project;", "extension", "Lcom/bytedance/rheatrace/plugin/extension/RheaBuildExtension;", "(Lorg/gradle/api/Project;Lcom/bytedance/rheatrace/plugin/extension/RheaBuildExtension;)V", "mappingFileMap", "Ljava/util/HashMap;", "", "Ljava/io/File;", "Lkotlin/collections/HashMap;", "getMappingFileMap", "()Ljava/util/HashMap;", "getProject", "()Lorg/gradle/api/Project;", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getParameterInputs", "", "", "getScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getSecondaryFiles", "", "Lcom/android/build/api/transform/SecondaryFile;", "isIncremental", "", "transform", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "transformArgs", "Lcom/bytedance/rheatrace/plugin/transform/TransformArgs;", "Companion", "rhea-gradle-plugin"})
public abstract class RheaBaseTransform
extends Transform {
    @NotNull
    private final HashMap<String, File> mappingFileMap;
    @NotNull
    private final Project project;
    private final RheaBuildExtension extension;
    @NotNull
    public static final String TAG = "Rhea:Transform";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final HashMap<String, File> getMappingFileMap() {
        return this.mappingFileMap;
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set set = TransformManager.CONTENT_CLASS;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"TransformManager.CONTENT_CLASS");
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Set set = TransformManager.SCOPE_FULL_PROJECT;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"TransformManager.SCOPE_FULL_PROJECT");
        return set;
    }

    public boolean isIncremental() {
        return true;
    }

    @Nullable
    public Map<String, Object> getParameterInputs() {
        HashMap inputs = new HashMap();
        if (this.extension.getCompilation() != null) {
            ((Map)inputs).put("compilation", String.valueOf(this.extension.getCompilation()));
        }
        if (this.extension.getRuntime() != null) {
            ((Map)inputs).put("runtime", String.valueOf(this.extension.getRuntime()));
        }
        return inputs;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<SecondaryFile> getSecondaryFiles() {
        if (this.extension.getCompilation() != null) {
            TraceCompilation traceCompilation = this.extension.getCompilation();
            if (traceCompilation == null) {
                Intrinsics.throwNpe();
            }
            File applyMethodMappingFile = new File(traceCompilation.getApplyMethodMappingFilePath());
            TraceCompilation traceCompilation2 = this.extension.getCompilation();
            if (traceCompilation2 == null) {
                Intrinsics.throwNpe();
            }
            File traceFilterFile = new File(traceCompilation2.getTraceFilterFilePath());
            boolean bl = false;
            List pathList = new ArrayList();
            if (applyMethodMappingFile.exists()) {
                String string = applyMethodMappingFile.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"applyMethodMappingFile.absolutePath");
                pathList.add(string);
            }
            if (traceFilterFile.exists()) {
                String string = traceFilterFile.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"traceFilterFile.absolutePath");
                pathList.add(string);
            }
            Collection collection = pathList;
            boolean bl2 = false;
            if (!collection.isEmpty()) {
                void $this$toTypedArray$iv;
                Collection collection2 = pathList;
                Project project = this.project;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] stringArray2 = stringArray;
                ConfigurableFileCollection files = project.files((Object[])Arrays.copyOf(stringArray2, stringArray2.length));
                boolean bl3 = false;
                Set secondaryFiles = new LinkedHashSet();
                SecondaryFile secondaryFile = SecondaryFile.nonIncremental((FileCollection)((FileCollection)files));
                Intrinsics.checkExpressionValueIsNotNull((Object)secondaryFile, (String)"SecondaryFile.nonIncremental(files)");
                secondaryFiles.add(secondaryFile);
                return secondaryFiles;
            }
        }
        Collection collection = super.getSecondaryFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"super.getSecondaryFiles()");
        return collection;
    }

    public void transform(@NotNull TransformInvocation transformInvocation) {
        String string;
        String variantName;
        Intrinsics.checkParameterIsNotNull((Object)transformInvocation, (String)"transformInvocation");
        super.transform(transformInvocation);
        Context context = transformInvocation.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"transformInvocation.context");
        String string2 = variantName = context.getVariantName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"variantName");
        File mergedManifest = AGPCompat.INSTANCE.getMergedManifestFile(this.project, string2);
        String applicationName = ManifestUtil.INSTANCE.readApplicationName(mergedManifest);
        File file = this.mappingFileMap.get(variantName);
        File mappingFileDir = file != null ? file.getParentFile() : null;
        File file2 = mappingFileDir;
        RheaLog.INSTANCE.i(TAG, "mappingFile path: " + (file2 != null ? file2.getAbsolutePath() : null), new Object[0]);
        if (mappingFileDir == null) {
            Joiner joiner = Joiner.on((char)File.separatorChar);
            File file3 = this.project.getBuildDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"project.buildDir");
            string = joiner.join((Object)file3.getAbsolutePath(), (Object)"outputs", new Object[]{"mapping", variantName});
        } else {
            string = mappingFileDir.getAbsolutePath();
        }
        String mappingOutput = string;
        Joiner joiner = Joiner.on((char)File.separatorChar);
        File file4 = this.project.getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"project.buildDir");
        String traceClassOutputDir = joiner.join((Object)file4.getAbsolutePath(), (Object)"rhea-trace", new Object[]{"outputs", "trace-class", variantName});
        String methodMappingFilePath = RheaFileUtils.INSTANCE.getMethodMapFilePath(this.project, variantName);
        String ignoreMethodMappingFilePath = RheaFileUtils.INSTANCE.getIgnoreMethodMapFilePath(this.project, variantName);
        String string3 = traceClassOutputDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"traceClassOutputDir");
        String string4 = mappingOutput;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"mappingOutput");
        TransformArgs transformArgs = new TransformArgs(applicationName, string3, string4, methodMappingFilePath, ignoreMethodMappingFilePath, this.extension.getCompilation());
        this.transform(transformInvocation, transformArgs);
    }

    public abstract void transform(@NotNull TransformInvocation var1, @NotNull TransformArgs var2);

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public RheaBaseTransform(@NotNull Project project, @NotNull RheaBuildExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        this.project = project;
        this.extension = extension;
        this.mappingFileMap = new HashMap();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bytedance/rheatrace/plugin/transform/RheaBaseTransform$Companion;", "", "()V", "TAG", "", "rhea-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

