/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin.compiling;

import com.android.build.api.transform.Status;
import com.bytedance.rheatrace.common.utils.FileUtil;
import com.bytedance.rheatrace.common.utils.RheaLog;
import com.google.common.hash.Hashing;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u001a\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/CollectJarInputTask;", "Ljava/lang/Runnable;", "inputJar", "Ljava/io/File;", "inputJarStatus", "Lcom/android/build/api/transform/Status;", "inputToOutput", "", "isIncremental", "", "traceClassFileOutput", "legacyReplaceFile", "Lkotlin/Function2;", "", "resultOfJarInputToOut", "", "(Ljava/io/File;Lcom/android/build/api/transform/Status;Ljava/util/Map;ZLjava/io/File;Lkotlin/jvm/functions/Function2;Ljava/util/Map;)V", "getUniqueJarName", "", "jarFile", "handle", "", "run", "Companion", "rhea-gradle-plugin"})
public final class CollectJarInputTask
implements Runnable {
    private final File inputJar;
    private final Status inputJarStatus;
    private final Map<File, File> inputToOutput;
    private final boolean isIncremental;
    private final File traceClassFileOutput;
    private final Function2<File, File, Object> legacyReplaceFile;
    private final Map<File, File> resultOfJarInputToOut;
    private static final String TAG = "CollectJarInputTask";
    public static final Companion Companion = new Companion(null);

    @Override
    public void run() {
        try {
            this.handle();
        }
        catch (Exception e) {
            e.printStackTrace();
            RheaLog.INSTANCE.e(TAG, "%s", new Object[]{e.toString()});
        }
    }

    private final void handle() {
        block11: {
            File jarOutput;
            File file;
            File jarInput = this.inputJar;
            if (this.inputToOutput.containsKey(jarInput)) {
                File file2 = this.inputToOutput.get(jarInput);
                if (file2 == null) {
                    Intrinsics.throwNpe();
                }
                file = file2;
            } else {
                file = jarOutput = new File(this.traceClassFileOutput, this.getUniqueJarName(jarInput));
            }
            if (!this.isIncremental && jarOutput.exists()) {
                jarOutput.delete();
            }
            if (!jarOutput.getParentFile().exists()) {
                jarOutput.getParentFile().mkdirs();
            }
            if (FileUtil.INSTANCE.isRealZipOrJar(jarInput)) {
                if (this.isIncremental) {
                    if (this.inputJarStatus == Status.ADDED || this.inputJarStatus == Status.CHANGED) {
                        this.resultOfJarInputToOut.put(jarInput, jarOutput);
                    } else if (this.inputJarStatus == Status.REMOVED) {
                        jarOutput.delete();
                    }
                } else {
                    this.resultOfJarInputToOut.put(jarInput, jarOutput);
                }
            }
            Function2<File, File, Object> function2 = this.legacyReplaceFile;
            if (function2 == null) break block11;
            function2.invoke((Object)jarInput, (Object)jarOutput);
        }
    }

    private final String getUniqueJarName(File jarFile) {
        String string;
        String origJarName = jarFile.getName();
        String string2 = Hashing.sha1().hashString((CharSequence)jarFile.getPath(), Charsets.UTF_16LE).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Hashing.sha1().hashStrin\u2026sets.UTF_16LE).toString()");
        String hashing = string2;
        String string3 = origJarName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"origJarName");
        int dotPos = StringsKt.lastIndexOf$default((CharSequence)string3, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotPos < 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string4 = "%s_%s";
            Object[] objectArray = new Object[]{origJarName, hashing};
            boolean bl = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
        } else {
            String string6 = origJarName;
            int n = 0;
            boolean bl = false;
            String string7 = string6.substring(n, dotPos);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String nameWithoutDotExt = string7;
            String string8 = origJarName;
            bl = false;
            String string9 = string8.substring(dotPos);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
            String dotExt = string9;
            string8 = StringCompanionObject.INSTANCE;
            String string10 = "%s_%s%s";
            Object[] objectArray = new Object[]{nameWithoutDotExt, hashing, dotExt};
            boolean bl2 = false;
            String string11 = String.format(string10, Arrays.copyOf(objectArray, objectArray.length));
            string = string11;
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"java.lang.String.format(format, *args)");
        }
        return string;
    }

    public CollectJarInputTask(@NotNull File inputJar, @NotNull Status inputJarStatus, @NotNull Map<File, ? extends File> inputToOutput, boolean isIncremental, @NotNull File traceClassFileOutput, @Nullable Function2<? super File, ? super File, ? extends Object> legacyReplaceFile2, @NotNull Map<File, File> resultOfJarInputToOut) {
        Intrinsics.checkParameterIsNotNull((Object)inputJar, (String)"inputJar");
        Intrinsics.checkParameterIsNotNull((Object)inputJarStatus, (String)"inputJarStatus");
        Intrinsics.checkParameterIsNotNull(inputToOutput, (String)"inputToOutput");
        Intrinsics.checkParameterIsNotNull((Object)traceClassFileOutput, (String)"traceClassFileOutput");
        Intrinsics.checkParameterIsNotNull(resultOfJarInputToOut, (String)"resultOfJarInputToOut");
        this.inputJar = inputJar;
        this.inputJarStatus = inputJarStatus;
        this.inputToOutput = inputToOutput;
        this.isIncremental = isIncremental;
        this.traceClassFileOutput = traceClassFileOutput;
        this.legacyReplaceFile = legacyReplaceFile2;
        this.resultOfJarInputToOut = resultOfJarInputToOut;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/CollectJarInputTask$Companion;", "", "()V", "TAG", "", "rhea-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

