/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin.compiling;

import com.bytedance.rheatrace.common.retrace.MappingCollector;
import com.bytedance.rheatrace.plugin.compiling.TraceMethod;
import com.bytedance.rheatrace.plugin.compiling.TraceMethodAdapter;
import com.bytedance.rheatrace.plugin.compiling.filter.TraceMethodFilter;
import com.bytedance.rheatrace.plugin.extension.TraceCompilation;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0007\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002JI\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u0018H\u0016JA\u0010'\u001a\u0004\u0018\u00010\u001c2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010\t2\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010*R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/RheaTraceClassVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "i", "", "classVisitor", "mappingCollector", "Lcom/bytedance/rheatrace/common/retrace/MappingCollector;", "collectedMethodMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/bytedance/rheatrace/plugin/compiling/TraceMethod;", "applicationName", "traceCompilation", "Lcom/bytedance/rheatrace/plugin/extension/TraceCompilation;", "traceMethodFilter", "Lcom/bytedance/rheatrace/plugin/compiling/filter/TraceMethodFilter;", "(ILorg/objectweb/asm/ClassVisitor;Lcom/bytedance/rheatrace/common/retrace/MappingCollector;Ljava/util/concurrent/ConcurrentHashMap;Ljava/lang/String;Lcom/bytedance/rheatrace/plugin/extension/TraceCompilation;Lcom/bytedance/rheatrace/plugin/compiling/filter/TraceMethodFilter;)V", "className", "isApplication", "", "needCreateAttachBaseContext", "needCreateOnCreate", "superName", "createAttachBaseContextForApplication", "", "createOnCreateForApplication", "instrAttachBaseContextForRheaTrace", "mv", "Lorg/objectweb/asm/MethodVisitor;", "instrOnCreateForRheaTrace", "visit", "version", "access", "name", "signature", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitEnd", "visitMethod", "desc", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "rhea-gradle-plugin"})
public final class RheaTraceClassVisitor
extends ClassVisitor {
    private String superName;
    private String className;
    private boolean isApplication;
    private boolean needCreateOnCreate;
    private boolean needCreateAttachBaseContext;
    private final MappingCollector mappingCollector;
    private ConcurrentHashMap<String, TraceMethod> collectedMethodMap;
    private final String applicationName;
    private final TraceCompilation traceCompilation;
    private final TraceMethodFilter traceMethodFilter;

    public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.className = name;
        this.isApplication = Intrinsics.areEqual((Object)StringsKt.replace$default((String)name, (String)"/", (String)".", (boolean)false, (int)4, null), (Object)this.applicationName);
        super.visit(version, access, name, signature, superName, interfaces);
        CharSequence charSequence = superName;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            this.superName = superName;
        }
    }

    @Nullable
    public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        if (this.cv == null) {
            return null;
        }
        if ((access & 0x400) > 0) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.isApplication) {
            if (Intrinsics.areEqual((Object)"attachBaseContext", (Object)name)) {
                this.needCreateAttachBaseContext = false;
                MethodVisitor methodVisitor = mv;
                Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor, (String)"mv");
                this.instrAttachBaseContextForRheaTrace(methodVisitor);
            }
            if (Intrinsics.areEqual((Object)"onCreate", (Object)name)) {
                this.needCreateOnCreate = false;
                MethodVisitor methodVisitor = mv;
                Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor, (String)"mv");
                this.instrOnCreateForRheaTrace(methodVisitor);
            }
        }
        MethodVisitor methodVisitor = mv;
        Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor, (String)"mv");
        String string = this.className;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"className");
        }
        return (MethodVisitor)new TraceMethodAdapter(this.api, methodVisitor, access, name, desc, string, this.mappingCollector, this.collectedMethodMap, this.traceCompilation, this.traceMethodFilter);
    }

    public void visitEnd() {
        if (this.isApplication && this.needCreateAttachBaseContext) {
            this.createAttachBaseContextForApplication();
        }
        if (this.isApplication && this.needCreateOnCreate) {
            this.createOnCreateForApplication();
        }
        super.visitEnd();
    }

    private final void createAttachBaseContextForApplication() {
        MethodVisitor mv;
        MethodVisitor methodVisitor = mv = this.cv.visitMethod(4, "attachBaseContext", "(Landroid/content/Context;)V", null, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor, (String)"mv");
        this.instrAttachBaseContextForRheaTrace(methodVisitor);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, this.superName, "attachBaseContext", "(Landroid/content/Context;)V", false);
        mv.visitInsn(177);
        mv.visitEnd();
    }

    private final void instrAttachBaseContextForRheaTrace(MethodVisitor mv) {
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "com/bytedance/rheatrace/core/TraceApplicationLike", "attachBaseContext", "(Landroid/content/Context;)V", false);
    }

    private final void createOnCreateForApplication() {
        MethodVisitor mv = this.cv.visitMethod(4, "onCreate", "(Landroid/content/Context;)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, this.superName, "onCreate", "()V", false);
        MethodVisitor methodVisitor = mv;
        Intrinsics.checkExpressionValueIsNotNull((Object)methodVisitor, (String)"mv");
        this.instrOnCreateForRheaTrace(methodVisitor);
        mv.visitInsn(177);
        mv.visitEnd();
    }

    private final void instrOnCreateForRheaTrace(MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "com/bytedance/rheatrace/core/TraceApplicationLike", "onCreate", "(Landroid/content/Context;)V", false);
    }

    public RheaTraceClassVisitor(int i, @NotNull ClassVisitor classVisitor, @NotNull MappingCollector mappingCollector, @NotNull ConcurrentHashMap<String, TraceMethod> collectedMethodMap, @Nullable String applicationName, @NotNull TraceCompilation traceCompilation, @NotNull TraceMethodFilter traceMethodFilter) {
        Intrinsics.checkParameterIsNotNull((Object)classVisitor, (String)"classVisitor");
        Intrinsics.checkParameterIsNotNull((Object)mappingCollector, (String)"mappingCollector");
        Intrinsics.checkParameterIsNotNull(collectedMethodMap, (String)"collectedMethodMap");
        Intrinsics.checkParameterIsNotNull((Object)traceCompilation, (String)"traceCompilation");
        Intrinsics.checkParameterIsNotNull((Object)traceMethodFilter, (String)"traceMethodFilter");
        super(i, classVisitor);
        this.mappingCollector = mappingCollector;
        this.collectedMethodMap = collectedMethodMap;
        this.applicationName = applicationName;
        this.traceCompilation = traceCompilation;
        this.traceMethodFilter = traceMethodFilter;
        this.superName = "";
        this.needCreateOnCreate = true;
        this.needCreateAttachBaseContext = true;
    }
}

