/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin.compiling;

import com.bytedance.rheatrace.common.retrace.MappingCollector;
import com.bytedance.rheatrace.common.retrace.MethodInfo;
import com.bytedance.rheatrace.common.utils.JavaToClassFormat;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u001d\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u001f\u001a\u00020\nJ\u0010\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"J\u0010\u0010#\u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"J\b\u0010$\u001a\u0004\u0018\u00010\nJ\u0010\u0010%\u001a\u00020&2\b\u0010!\u001a\u0004\u0018\u00010\"J\u0010\u0010'\u001a\u00020&2\b\u0010!\u001a\u0004\u0018\u00010\"J\u0006\u0010(\u001a\u00020\nJ\b\u0010)\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0006\"\u0004\b\u0015\u0010\bR\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u000e\u0010\u001c\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/TraceMethod;", "", "()V", "accessFlag", "", "getAccessFlag", "()I", "setAccessFlag", "(I)V", "value", "", "className", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "desc", "getDesc", "setDesc", "id", "getId", "setId", "isNativeMethod", "", "()Z", "methodName", "getMethodName", "setMethodName", "originClassName", "equals", "other", "getFullMethodName", "getOriginClassName", "processor", "Lcom/bytedance/rheatrace/common/retrace/MappingCollector;", "getOriginMethodName", "getReturnType", "proguard", "", "revert", "toIgnoreString", "toString", "Companion", "rhea-gradle-plugin"})
public class TraceMethod {
    private int id;
    private int accessFlag;
    @NotNull
    private String className = "";
    @NotNull
    private String methodName = "";
    @Nullable
    private String desc;
    private String originClassName = "";
    public static final Companion Companion = new Companion(null);

    public final int getId() {
        return this.id;
    }

    public final void setId(int n) {
        this.id = n;
    }

    public final int getAccessFlag() {
        return this.accessFlag;
    }

    public final void setAccessFlag(int n) {
        this.accessFlag = n;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    public final void setClassName(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.className = StringsKt.replace$default((String)value, (String)"/", (String)".", (boolean)false, (int)4, null);
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    public final void setMethodName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.methodName = string;
    }

    @Nullable
    public final String getDesc() {
        return this.desc;
    }

    public final void setDesc(@Nullable String string) {
        this.desc = string;
    }

    @NotNull
    public final String getFullMethodName() {
        return this.desc == null || this.isNativeMethod() ? this.className + '.' + this.methodName + "()" : this.className + '.' + this.methodName + this.desc;
    }

    @NotNull
    public final String getOriginMethodName(@Nullable MappingCollector processor) {
        if (processor == null) {
            return this.getFullMethodName();
        }
        this.originClassName = processor.originalClassName(this.className, this.className);
        String string = this.desc;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        MethodInfo methodInfo = processor.originalMethodInfo(this.className, this.methodName, string);
        String originMethodName = this.originClassName + '.' + methodInfo.getOriginalName() + '(' + methodInfo.getOriginalArguments() + ')' + methodInfo.getOriginalType();
        CharSequence charSequence = "\\$[A-Za-z0-9]{8}\\(";
        boolean bl = false;
        Regex regex = new Regex(charSequence);
        charSequence = originMethodName;
        String string2 = "(";
        boolean bl2 = false;
        originMethodName = regex.replace(charSequence, string2);
        return originMethodName;
    }

    @NotNull
    public final String getOriginClassName(@Nullable MappingCollector processor) {
        if (processor == null) {
            return this.className;
        }
        CharSequence charSequence = this.originClassName;
        boolean bl = false;
        if (charSequence.length() > 0) {
            return this.originClassName;
        }
        this.originClassName = processor.originalClassName(this.className, this.className);
        return this.originClassName;
    }

    public final void revert(@Nullable MappingCollector processor) {
        if (processor == null) {
            return;
        }
        String string = this.desc;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        MethodInfo methodInfo = processor.originalMethodInfo(this.className, this.methodName, string);
        this.methodName = methodInfo.getOriginalName();
        this.desc = JavaToClassFormat.INSTANCE.getMethodDescParams(methodInfo.getOriginalArguments()) + JavaToClassFormat.INSTANCE.getMethodDescReturn(methodInfo.getOriginalType());
        this.setClassName(processor.originalClassName(this.className, this.className));
    }

    public final void proguard(@Nullable MappingCollector processor) {
        if (processor == null) {
            return;
        }
        String string = this.desc;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        MethodInfo methodInfo = processor.obfuscatedMethodInfo(this.className, this.methodName, string);
        this.methodName = methodInfo.getOriginalName();
        this.desc = methodInfo.getDesc();
        this.setClassName(processor.proguardClassName(this.className, this.className));
    }

    @Nullable
    public final String getReturnType() {
        return TextUtils.isEmpty((CharSequence)this.desc) ? null : Type.getReturnType((String)this.desc).toString();
    }

    @NotNull
    public String toString() {
        return this.desc == null || this.isNativeMethod() ? "" + this.id + ',' + this.accessFlag + ',' + this.className + ' ' + this.methodName : "" + this.id + ',' + this.accessFlag + ',' + this.className + ' ' + this.methodName + ' ' + this.desc;
    }

    @NotNull
    public final String toIgnoreString() {
        return this.desc == null || this.isNativeMethod() ? this.className + ' ' + this.methodName : this.className + ' ' + this.methodName + ' ' + this.desc;
    }

    private final boolean isNativeMethod() {
        return (this.accessFlag & 0x100) != 0;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof TraceMethod ? Intrinsics.areEqual((Object)((TraceMethod)other).getFullMethodName(), (Object)this.getFullMethodName()) : false;
    }

    @JvmStatic
    @NotNull
    public static final TraceMethod create(int id, int accessFlag, @NotNull String className, @NotNull String methodName, @Nullable String desc) {
        return Companion.create(id, accessFlag, className, methodName, desc);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0007\u00a8\u0006\f"}, d2={"Lcom/bytedance/rheatrace/plugin/compiling/TraceMethod$Companion;", "", "()V", "create", "Lcom/bytedance/rheatrace/plugin/compiling/TraceMethod;", "id", "", "accessFlag", "className", "", "methodName", "desc", "rhea-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final TraceMethod create(int id, int accessFlag, @NotNull String className, @NotNull String methodName, @Nullable String desc) {
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
            TraceMethod traceMethod = new TraceMethod();
            traceMethod.setId(id);
            traceMethod.setAccessFlag(accessFlag);
            traceMethod.setClassName(className);
            traceMethod.setMethodName(methodName);
            traceMethod.setDesc(desc);
            return traceMethod;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

