/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin.internal.compat;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.bytedance.rheatrace.common.utils.RheaLog;
import com.bytedance.rheatrace.plugin.extension.RheaBuildExtension;
import com.bytedance.rheatrace.plugin.internal.compat.AGPVersion;
import com.bytedance.rheatrace.plugin.internal.compat.RheaTraceCompat;
import com.bytedance.rheatrace.plugin.internal.compat.VersionsCompat;
import com.bytedance.rheatrace.plugin.task.RheaTraceTasksManager;
import com.bytedance.rheatrace.plugin.transform.RheaTraceLegacyTransform;
import com.bytedance.rheatrace.plugin.transform.RheaTraceTransform;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/bytedance/rheatrace/plugin/internal/compat/RheaTraceCompat;", "", "()V", "createTransparentTransform", "Lcom/bytedance/rheatrace/plugin/transform/RheaTraceTransform;", "appExtension", "Lcom/android/build/gradle/AppExtension;", "project", "Lorg/gradle/api/Project;", "extension", "Lcom/bytedance/rheatrace/plugin/extension/RheaBuildExtension;", "inject", "", "legacyInject", "Companion", "rhea-gradle-plugin"})
public final class RheaTraceCompat {
    @NotNull
    public static final String TAG = "RheaTraceCompat";
    public static final Companion Companion = new Companion(null);

    public final void inject(@NotNull AppExtension appExtension, @NotNull Project project, @NotNull RheaBuildExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)appExtension, (String)"appExtension");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        boolean enableR8 = Intrinsics.areEqual((Object)"false", project.getProperties().get("android.enableR8")) ^ true;
        if (enableR8) {
            RheaLog.INSTANCE.i(TAG, "enableR8 is open , dont hook proguard task", new Object[0]);
            RheaTraceTransform transparentTransform = this.createTransparentTransform(appExtension, project, extension);
            project.afterEvaluate((Action)new Action<Project>(appExtension, transparentTransform){
                final /* synthetic */ AppExtension $appExtension;
                final /* synthetic */ RheaTraceTransform $transparentTransform;

                public final void execute(Project it) {
                    this.$appExtension.getApplicationVariants().all((Action)new Action<ApplicationVariant>(this){
                        final /* synthetic */ inject.1 this$0;

                        public final void execute(ApplicationVariant variant) {
                            Map map = this.this$0.$transparentTransform.getTransparentMap();
                            ApplicationVariant applicationVariant = variant;
                            Intrinsics.checkExpressionValueIsNotNull((Object)applicationVariant, (String)"variant");
                            String string = applicationVariant.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variant.name");
                            map.put(string, false);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.$appExtension = appExtension;
                    this.$transparentTransform = rheaTraceTransform;
                }
            });
        } else if (((Boolean)VersionsCompat.INSTANCE.getLessThan().invoke((Object)AGPVersion.AGP_3_6_0)).booleanValue()) {
            RheaLog.INSTANCE.i(TAG, "AGPVersion lessThan AGP_3_6_0, hook proguard task", new Object[0]);
            this.legacyInject(appExtension, project, extension);
        } else if (((Boolean)VersionsCompat.INSTANCE.getLessThan().invoke((Object)AGPVersion.AGP_4_0_0)).booleanValue()) {
            RheaLog.INSTANCE.i(TAG, "dont hook proguard task", new Object[0]);
            RheaTraceTransform transparentTransform = this.createTransparentTransform(appExtension, project, extension);
            project.afterEvaluate((Action)new Action<Project>(appExtension, transparentTransform){
                final /* synthetic */ AppExtension $appExtension;
                final /* synthetic */ RheaTraceTransform $transparentTransform;

                public final void execute(Project it) {
                    this.$appExtension.getApplicationVariants().all((Action)new Action<ApplicationVariant>(this){
                        final /* synthetic */ inject.2 this$0;

                        public final void execute(ApplicationVariant variant) {
                            Map map = this.this$0.$transparentTransform.getTransparentMap();
                            ApplicationVariant applicationVariant = variant;
                            Intrinsics.checkExpressionValueIsNotNull((Object)applicationVariant, (String)"variant");
                            String string = applicationVariant.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variant.name");
                            map.put(string, false);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.$appExtension = appExtension;
                    this.$transparentTransform = rheaTraceTransform;
                }
            });
        } else if (((Boolean)VersionsCompat.INSTANCE.getGreatThanOrEqual().invoke((Object)AGPVersion.AGP_4_0_0)).booleanValue()) {
            RheaLog.INSTANCE.i(TAG, "AGPVersion greatThanOrEqual AGP_4_0_0, hook proguard task", new Object[0]);
            RheaTraceTransform transparentTransform = this.createTransparentTransform(appExtension, project, extension);
            project.afterEvaluate((Action)new Action<Project>(appExtension, transparentTransform, project, extension){
                final /* synthetic */ AppExtension $appExtension;
                final /* synthetic */ RheaTraceTransform $transparentTransform;
                final /* synthetic */ Project $project;
                final /* synthetic */ RheaBuildExtension $extension;

                public final void execute(Project it) {
                    this.$appExtension.getApplicationVariants().all((Action)new Action<ApplicationVariant>(this){
                        final /* synthetic */ inject.3 this$0;

                        public final void execute(ApplicationVariant variant) {
                            Map map = this.this$0.$transparentTransform.getMappingFileMap();
                            ApplicationVariant applicationVariant = variant;
                            Intrinsics.checkExpressionValueIsNotNull((Object)applicationVariant, (String)"variant");
                            String string = applicationVariant.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variant.name");
                            map.put(string, variant.getMappingFile());
                            if (variant.getBuildType().isMinifyEnabled()) {
                                RheaTraceTasksManager.INSTANCE.createRheaTraceTask(this.this$0.$project, variant, this.this$0.$extension);
                            } else {
                                Map map2 = this.this$0.$transparentTransform.getTransparentMap();
                                String string2 = variant.getName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"variant.name");
                                map2.put(string2, false);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.$appExtension = appExtension;
                    this.$transparentTransform = rheaTraceTransform;
                    this.$project = project;
                    this.$extension = rheaBuildExtension;
                }
            });
        } else {
            RheaLog.INSTANCE.e(TAG, "rheaTrace does not support Android Gradle Plugin %s", new Object[]{VersionsCompat.INSTANCE.getAndroidGradlePluginVersion()});
        }
    }

    private final RheaTraceTransform createTransparentTransform(AppExtension appExtension, Project project, RheaBuildExtension extension) {
        RheaTraceTransform transparentTransform = new RheaTraceTransform(project, extension);
        appExtension.registerTransform((Transform)transparentTransform, new Object[0]);
        return transparentTransform;
    }

    private final void legacyInject(AppExtension appExtension, Project project, RheaBuildExtension extension) {
        project.afterEvaluate((Action)new Action<Project>(appExtension, extension, project){
            final /* synthetic */ AppExtension $appExtension;
            final /* synthetic */ RheaBuildExtension $extension;
            final /* synthetic */ Project $project;

            public final void execute(Project it) {
                this.$appExtension.getApplicationVariants().all((Action)new Action<ApplicationVariant>(this){
                    final /* synthetic */ legacyInject.1 this$0;

                    public final void execute(ApplicationVariant it) {
                        RheaBuildExtension rheaBuildExtension = this.this$0.$extension;
                        Project project = this.this$0.$project;
                        ApplicationVariant applicationVariant = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)applicationVariant, (String)"it");
                        RheaTraceLegacyTransform.Companion.inject(rheaBuildExtension, project, (BaseVariant)applicationVariant);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$appExtension = appExtension;
                this.$extension = rheaBuildExtension;
                this.$project = project;
            }
        });
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bytedance/rheatrace/plugin/internal/compat/RheaTraceCompat$Companion;", "", "()V", "TAG", "", "rhea-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

