/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin.transform;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.bytedance.rheatrace.common.utils.ReflectUtil;
import com.bytedance.rheatrace.common.utils.RheaLog;
import com.bytedance.rheatrace.plugin.compiling.TraceWeaver;
import com.bytedance.rheatrace.plugin.extension.RheaBuildExtension;
import com.bytedance.rheatrace.plugin.extension.TraceCompilation;
import com.bytedance.rheatrace.plugin.transform.RheaBaseTransform;
import com.bytedance.rheatrace.plugin.transform.TransformArgs;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u0018\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lcom/bytedance/rheatrace/plugin/transform/RheaTraceLegacyTransform;", "Lcom/bytedance/rheatrace/plugin/transform/RheaBaseTransform;", "project", "Lorg/gradle/api/Project;", "extension", "Lcom/bytedance/rheatrace/plugin/extension/RheaBuildExtension;", "origTransform", "Lcom/android/build/api/transform/Transform;", "(Lorg/gradle/api/Project;Lcom/bytedance/rheatrace/plugin/extension/RheaBuildExtension;Lcom/android/build/api/transform/Transform;)V", "getOrigTransform", "()Lcom/android/build/api/transform/Transform;", "setOrigTransform", "(Lcom/android/build/api/transform/Transform;)V", "doTransform", "", "invocation", "Lcom/android/build/api/transform/TransformInvocation;", "transformArgs", "Lcom/bytedance/rheatrace/plugin/transform/TransformArgs;", "getName", "", "replaceChangedFile", "dirInput", "Lcom/android/build/api/transform/DirectoryInput;", "changedFiles", "", "Ljava/io/File;", "Lcom/android/build/api/transform/Status;", "replaceFile", "input", "Lcom/android/build/api/transform/QualifiedContent;", "newFile", "transform", "transformInvocation", "Companion", "rhea-gradle-plugin"})
public final class RheaTraceLegacyTransform
extends RheaBaseTransform {
    @NotNull
    private Transform origTransform;
    @NotNull
    public static final String TAG = "rheaTraceLegacyTransform";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getName() {
        return TAG;
    }

    @Override
    public void transform(@NotNull TransformInvocation transformInvocation, @NotNull TransformArgs transformArgs) {
        Intrinsics.checkParameterIsNotNull((Object)transformInvocation, (String)"transformInvocation");
        Intrinsics.checkParameterIsNotNull((Object)transformArgs, (String)"transformArgs");
        RheaLog.INSTANCE.i(TAG, "start run RheaTraceLegacyTransform", new Object[0]);
        long start = System.currentTimeMillis();
        try {
            this.doTransform(transformInvocation, transformArgs);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        long cost = System.currentTimeMillis() - start;
        long begin = System.currentTimeMillis();
        this.origTransform.transform(transformInvocation);
        long origTransformCost = System.currentTimeMillis() - begin;
        RheaLog.INSTANCE.i(TAG, "[transform] cost time: %dms %s:%s ms RheaTraceTransform:%sms", new Object[]{System.currentTimeMillis() - start, this.origTransform.getClass().getSimpleName(), origTransformCost, cost});
    }

    private final void doTransform(TransformInvocation invocation, TransformArgs transformArgs) {
        long start = System.currentTimeMillis();
        boolean isIncremental = invocation.isIncremental() && this.isIncremental();
        ConcurrentHashMap changedFiles = new ConcurrentHashMap();
        ArrayList<File> inputFiles = new ArrayList<File>();
        ConcurrentHashMap fileToInput = new ConcurrentHashMap();
        Iterator iterator = invocation.getInputs().iterator();
        while (iterator.hasNext()) {
            TransformInput input;
            TransformInput transformInput = input = (TransformInput)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"input");
            Iterator iterator2 = transformInput.getDirectoryInputs().iterator();
            while (iterator2.hasNext()) {
                DirectoryInput directoryInput;
                DirectoryInput directoryInput2 = directoryInput = (DirectoryInput)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)directoryInput2, (String)"directoryInput");
                changedFiles.putAll(directoryInput2.getChangedFiles());
                inputFiles.add(directoryInput.getFile());
                Map map = fileToInput;
                File file = directoryInput.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"directoryInput.file");
                map.put(file, directoryInput);
            }
            for (JarInput jarInput : input.getJarInputs()) {
                Map map = changedFiles;
                JarInput jarInput2 = jarInput;
                Intrinsics.checkExpressionValueIsNotNull((Object)jarInput2, (String)"jarInput");
                File file = jarInput2.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"jarInput.file");
                Status status = jarInput.getStatus();
                Intrinsics.checkExpressionValueIsNotNull((Object)status, (String)"jarInput.status");
                map.put(file, status);
                inputFiles.add(jarInput.getFile());
                Map map2 = fileToInput;
                File file2 = jarInput.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"jarInput.file");
                map2.put(file2, jarInput);
            }
        }
        if (inputFiles.size() == 0) {
            RheaLog.INSTANCE.i(TAG, "rhea trace do not find any input files", new Object[0]);
            return;
        }
        Function2 legacyReplaceChangedFile2 = (Function2)new Function2<File, Map<File, ? extends Status>, Object>(this, fileToInput){
            final /* synthetic */ RheaTraceLegacyTransform this$0;
            final /* synthetic */ ConcurrentHashMap $fileToInput;

            @NotNull
            public final Object invoke(@NotNull File inputDir, @NotNull Map<File, ? extends Status> map) {
                Intrinsics.checkParameterIsNotNull((Object)inputDir, (String)"inputDir");
                Intrinsics.checkParameterIsNotNull(map, (String)"map");
                V v = this.$fileToInput.get(inputDir);
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.api.transform.DirectoryInput");
                }
                RheaTraceLegacyTransform.access$replaceChangedFile(this.this$0, (DirectoryInput)v, map);
                return inputDir;
            }
            {
                this.this$0 = rheaTraceLegacyTransform;
                this.$fileToInput = concurrentHashMap;
                super(2);
            }
        };
        Function2 legacyReplaceFile2 = (Function2)new Function2<File, File, Object>(this, fileToInput){
            final /* synthetic */ RheaTraceLegacyTransform this$0;
            final /* synthetic */ ConcurrentHashMap $fileToInput;

            @NotNull
            public final Object invoke(@NotNull File input, @NotNull File output) {
                Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
                V v = this.$fileToInput.get(input);
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.api.transform.QualifiedContent");
                }
                RheaTraceLegacyTransform.access$replaceFile(this.this$0, (QualifiedContent)v, output);
                return input;
            }
            {
                this.this$0 = rheaTraceLegacyTransform;
                this.$fileToInput = concurrentHashMap;
                super(2);
            }
        };
        String string = transformArgs.getApplicationName();
        String string2 = transformArgs.getMappingOutputDir();
        String string3 = transformArgs.getMethodMappingFilePath();
        String string4 = transformArgs.getIgnoreMethodMappingFilePath();
        TraceCompilation traceCompilation = transformArgs.getTraceCompilation();
        Context context = invocation.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"invocation.context");
        String string5 = context.getVariantName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"invocation.context.variantName");
        new TraceWeaver(string, string2, string3, string4, traceCompilation, string5, this.getProject()).doTransform((Collection<? extends File>)inputFiles, changedFiles, new ConcurrentHashMap(), isIncremental, new File(transformArgs.getTraceClassOutputDir()), (Function2<? super File, ? super Map<File, ? extends Status>, ? extends Object>)legacyReplaceChangedFile2, (Function2<? super File, ? super File, ? extends Object>)legacyReplaceFile2);
        long cost = System.currentTimeMillis() - start;
        RheaLog.INSTANCE.i(TAG, " Insert rhea trace instrumentations cost time: %sms.", new Object[]{cost});
    }

    private final void replaceFile(QualifiedContent input, File newFile) {
        Field fileField = ReflectUtil.INSTANCE.getDeclaredFieldRecursive(input.getClass(), "file");
        fileField.set(input, newFile);
    }

    private final void replaceChangedFile(DirectoryInput dirInput, Map<File, ? extends Status> changedFiles) {
        Field changedFilesField = ReflectUtil.INSTANCE.getDeclaredFieldRecursive(dirInput.getClass(), "changedFiles");
        changedFilesField.set(dirInput, changedFiles);
    }

    @NotNull
    public final Transform getOrigTransform() {
        return this.origTransform;
    }

    public final void setOrigTransform(@NotNull Transform transform) {
        Intrinsics.checkParameterIsNotNull((Object)transform, (String)"<set-?>");
        this.origTransform = transform;
    }

    public RheaTraceLegacyTransform(@NotNull Project project, @NotNull RheaBuildExtension extension, @NotNull Transform origTransform) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        Intrinsics.checkParameterIsNotNull((Object)origTransform, (String)"origTransform");
        super(project, extension);
        this.origTransform = origTransform;
    }

    public static final /* synthetic */ void access$replaceChangedFile(RheaTraceLegacyTransform $this, DirectoryInput dirInput, Map changedFiles) {
        $this.replaceChangedFile(dirInput, changedFiles);
    }

    public static final /* synthetic */ void access$replaceFile(RheaTraceLegacyTransform $this, QualifiedContent input, File newFile) {
        $this.replaceFile(input, newFile);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/bytedance/rheatrace/plugin/transform/RheaTraceLegacyTransform$Companion;", "", "()V", "TAG", "", "getTransformTaskName", "", "buildTypeSuffix", "(Ljava/lang/String;)[Ljava/lang/String;", "inject", "", "extension", "Lcom/bytedance/rheatrace/plugin/extension/RheaBuildExtension;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "rhea-gradle-plugin"})
    public static final class Companion {
        public final void inject(@NotNull RheaBuildExtension extension, @NotNull Project project, @NotNull BaseVariant variant) {
            Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
            String string = variant.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variant.name");
            String[] hardTask = this.getTransformTaskName(string);
            block0: for (Task task : project.getTasks()) {
                for (String str : hardTask) {
                    Task task2 = task;
                    Intrinsics.checkExpressionValueIsNotNull((Object)task2, (String)"task");
                    if (!StringsKt.equals((String)task2.getName(), (String)str, (boolean)true) || !(task instanceof TransformTask)) continue;
                    Field field = ReflectUtil.INSTANCE.getDeclaredFieldRecursive(task.getClass(), "transform");
                    Transform transform = ((TransformTask)task).getTransform();
                    Intrinsics.checkExpressionValueIsNotNull((Object)transform, (String)"task.transform");
                    RheaTraceLegacyTransform legacyTransform = new RheaTraceLegacyTransform(project, extension, transform);
                    Map map = legacyTransform.getMappingFileMap();
                    String string2 = variant.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"variant.name");
                    map.put(string2, variant.getMappingFile());
                    field.set(task, (Object)legacyTransform);
                    RheaLog.INSTANCE.i(RheaTraceLegacyTransform.TAG, "successfully inject task:" + ((TransformTask)task).getName(), new Object[0]);
                    continue block0;
                }
            }
        }

        private final String[] getTransformTaskName(String buildTypeSuffix) {
            return new String[]{"transformClassesWithDexBuilderFor" + buildTypeSuffix, "transformClassesWithDexFor" + buildTypeSuffix};
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

