/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.plugin.transform;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.utils.FileUtils;
import com.bytedance.rheatrace.common.utils.RheaLog;
import com.bytedance.rheatrace.plugin.compiling.TraceWeaver;
import com.bytedance.rheatrace.plugin.extension.RheaBuildExtension;
import com.bytedance.rheatrace.plugin.extension.TraceCompilation;
import com.bytedance.rheatrace.plugin.transform.RheaBaseTransform;
import com.bytedance.rheatrace.plugin.transform.RheaTraceTransform$WhenMappings;
import com.bytedance.rheatrace.plugin.transform.TransformArgs;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\tH\u0016J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002R-\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/bytedance/rheatrace/plugin/transform/RheaTraceTransform;", "Lcom/bytedance/rheatrace/plugin/transform/RheaBaseTransform;", "project", "Lorg/gradle/api/Project;", "extension", "Lcom/bytedance/rheatrace/plugin/extension/RheaBuildExtension;", "(Lorg/gradle/api/Project;Lcom/bytedance/rheatrace/plugin/extension/RheaBuildExtension;)V", "transparentMap", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getTransparentMap", "()Ljava/util/HashMap;", "copyFileAndMkdirsAsNeed", "", "from", "Ljava/io/File;", "to", "getName", "toOutputFile", "outputDir", "inputDir", "inputFile", "transform", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "transformArgs", "Lcom/bytedance/rheatrace/plugin/transform/TransformArgs;", "transforming", "invocation", "transparent", "Companion", "rhea-gradle-plugin"})
public final class RheaTraceTransform
extends RheaBaseTransform {
    @NotNull
    private final HashMap<String, Boolean> transparentMap;
    @NotNull
    public static final String TAG = "RheaTraceTransform";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final HashMap<String, Boolean> getTransparentMap() {
        return this.transparentMap;
    }

    @NotNull
    public String getName() {
        return "rheaTrace";
    }

    @Override
    public void transform(@NotNull TransformInvocation transformInvocation, @NotNull TransformArgs transformArgs) {
        Intrinsics.checkParameterIsNotNull((Object)transformInvocation, (String)"transformInvocation");
        Intrinsics.checkParameterIsNotNull((Object)transformArgs, (String)"transformArgs");
        Context context = transformInvocation.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"transformInvocation.context");
        Boolean bl = this.transparentMap.getOrDefault(context.getVariantName(), true);
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"transparentMap.getOrDefa\u2026ontext.variantName, true)");
        if (bl.booleanValue()) {
            this.transparent(transformInvocation);
        } else {
            this.transforming(transformInvocation, transformArgs);
        }
    }

    private final void transparent(TransformInvocation invocation) {
        TransformOutputProvider transformOutputProvider = invocation.getOutputProvider();
        if (transformOutputProvider == null) {
            Intrinsics.throwNpe();
        }
        TransformOutputProvider outputProvider = transformOutputProvider;
        if (!invocation.isIncremental()) {
            outputProvider.deleteAll();
        }
        Iterator iterator = invocation.getInputs().iterator();
        while (iterator.hasNext()) {
            TransformInput ti;
            TransformInput transformInput = ti = (TransformInput)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"ti");
            Iterator iterator2 = transformInput.getJarInputs().iterator();
            block11: while (iterator2.hasNext()) {
                JarInput jarInput;
                JarInput jarInput2 = jarInput = (JarInput)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jarInput2, (String)"jarInput");
                File inputJar = jarInput2.getFile();
                File outputJar = outputProvider.getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                if (invocation.isIncremental()) {
                    Status status = jarInput.getStatus();
                    if (status == null) continue;
                    switch (RheaTraceTransform$WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                        case 1: {
                            continue block11;
                        }
                        case 2: 
                        case 3: {
                            File file = inputJar;
                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputJar");
                            File file2 = outputJar;
                            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"outputJar");
                            this.copyFileAndMkdirsAsNeed(file, file2);
                            continue block11;
                        }
                        case 4: {
                            FileUtils.delete((File)outputJar);
                            continue block11;
                        }
                    }
                    continue;
                }
                File file = inputJar;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputJar");
                File file3 = outputJar;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"outputJar");
                this.copyFileAndMkdirsAsNeed(file, file3);
            }
            iterator2 = ti.getDirectoryInputs().iterator();
            while (iterator2.hasNext()) {
                DirectoryInput directoryInput;
                DirectoryInput directoryInput2 = directoryInput = (DirectoryInput)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)directoryInput2, (String)"directoryInput");
                File inputDir = directoryInput2.getFile();
                File outputDir = outputProvider.getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
                if (invocation.isIncremental()) {
                    for (Map.Entry entry : directoryInput.getChangedFiles().entrySet()) {
                        File inputFile = (File)entry.getKey();
                        Status status = (Status)entry.getValue();
                        if (status == null) continue;
                        switch (RheaTraceTransform$WhenMappings.$EnumSwitchMapping$1[status.ordinal()]) {
                            case 1: {
                                break;
                            }
                            case 2: 
                            case 3: {
                                File file = inputFile;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputFile");
                                if (file.isDirectory()) break;
                                File file4 = outputDir;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"outputDir");
                                File file5 = inputDir;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"inputDir");
                                File outputFile = this.toOutputFile(file4, file5, inputFile);
                                this.copyFileAndMkdirsAsNeed(inputFile, outputFile);
                                break;
                            }
                            case 4: {
                                File file = outputDir;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir");
                                File file6 = inputDir;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"inputDir");
                                File file7 = inputFile;
                                Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"inputFile");
                                File outputFile = this.toOutputFile(file, file6, file7);
                                FileUtils.deleteIfExists((File)outputFile);
                                break;
                            }
                        }
                    }
                    continue;
                }
                for (File inputFile : FileUtils.getAllFiles((File)inputDir)) {
                    File file = outputDir;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir");
                    File file8 = inputDir;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file8, (String)"inputDir");
                    File file9 = inputFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file9, (String)"inputFile");
                    File out = this.toOutputFile(file, file8, file9);
                    this.copyFileAndMkdirsAsNeed(inputFile, out);
                }
            }
        }
    }

    private final void transforming(TransformInvocation invocation, TransformArgs transformArgs) {
        boolean isIncremental;
        long start = System.currentTimeMillis();
        TransformOutputProvider transformOutputProvider = invocation.getOutputProvider();
        if (transformOutputProvider == null) {
            Intrinsics.throwNpe();
        }
        TransformOutputProvider outputProvider = transformOutputProvider;
        boolean bl = isIncremental = invocation.isIncremental() && this.isIncremental();
        if (!isIncremental) {
            outputProvider.deleteAll();
        }
        ConcurrentHashMap changedFiles = new ConcurrentHashMap();
        ConcurrentHashMap inputToOutput = new ConcurrentHashMap();
        ArrayList<File> inputFiles = new ArrayList<File>();
        Iterator iterator = invocation.getInputs().iterator();
        while (iterator.hasNext()) {
            TransformInput input;
            TransformInput transformInput = input = (TransformInput)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)transformInput, (String)"input");
            Iterator iterator2 = transformInput.getDirectoryInputs().iterator();
            while (iterator2.hasNext()) {
                DirectoryInput directoryInput;
                DirectoryInput directoryInput2 = directoryInput = (DirectoryInput)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)directoryInput2, (String)"directoryInput");
                changedFiles.putAll(directoryInput2.getChangedFiles());
                File inputDir = directoryInput.getFile();
                inputFiles.add(inputDir);
                File outputDirectory = outputProvider.getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(), directoryInput.getScopes(), Format.DIRECTORY);
                Map map = inputToOutput;
                File file = inputDir;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputDir");
                File file2 = outputDirectory;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"outputDirectory");
                map.put(file, file2);
            }
            iterator2 = input.getJarInputs().iterator();
            while (iterator2.hasNext()) {
                JarInput jarInput;
                JarInput jarInput2 = jarInput = (JarInput)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jarInput2, (String)"jarInput");
                File inputFile = jarInput2.getFile();
                Map map = changedFiles;
                File file = inputFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputFile");
                Status status = jarInput.getStatus();
                Intrinsics.checkExpressionValueIsNotNull((Object)status, (String)"jarInput.status");
                map.put(file, status);
                inputFiles.add(inputFile);
                File outputJar = outputProvider.getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                Map map2 = inputToOutput;
                File file3 = outputJar;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"outputJar");
                map2.put(inputFile, file3);
            }
        }
        if (inputFiles.size() == 0) {
            RheaLog.INSTANCE.i(TAG, "rhea trace do not find any input files", new Object[0]);
            return;
        }
        String string = transformArgs.getApplicationName();
        String string2 = transformArgs.getMappingOutputDir();
        String string3 = transformArgs.getMethodMappingFilePath();
        String string4 = transformArgs.getIgnoreMethodMappingFilePath();
        TraceCompilation traceCompilation = transformArgs.getTraceCompilation();
        Context context = invocation.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"invocation.context");
        String string5 = context.getVariantName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"invocation.context.variantName");
        new TraceWeaver(string, string2, string3, string4, traceCompilation, string5, this.getProject()).doTransform((Collection<? extends File>)inputFiles, changedFiles, inputToOutput, isIncremental, new File(transformArgs.getTraceClassOutputDir()), null, null);
        long cost = System.currentTimeMillis() - start;
        RheaLog.INSTANCE.i(TAG, " Insert rhea trace instrumentations cost time: %sms.", new Object[]{cost});
    }

    private final void copyFileAndMkdirsAsNeed(File from, File to) {
        if (from.exists()) {
            to.getParentFile().mkdirs();
            FileUtils.copyFile((File)from, (File)to);
        }
    }

    private final File toOutputFile(File outputDir, File inputDir, File inputFile) {
        return new File(outputDir, FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir));
    }

    public RheaTraceTransform(@NotNull Project project, @NotNull RheaBuildExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        super(project, extension);
        this.transparentMap = new HashMap();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/bytedance/rheatrace/plugin/transform/RheaTraceTransform$Companion;", "", "()V", "TAG", "", "rhea-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

