/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Process;
import android.util.Log;
import com.bytedance.rheatrace.prop.TraceProperties;
import com.bytedance.rheatrace.server.HttpServer;
import com.bytedance.rheatrace.trace.TraceAbilityCenter;
import com.bytedance.rheatrace.trace.base.TraceAbility;
import com.bytedance.rheatrace.trace.base.TraceGlobal;
import com.bytedance.rheatrace.trace.base.TraceMeta;
import com.bytedance.rheatrace.utils.HandlerThreadUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class TraceManager {
    private static final String TAG = "RheaTrace:Manager";
    private String tracingDirPath;
    private long[] traceTokens = null;

    public static TraceManager getInstance() {
        return Holder.INSTANCE;
    }

    public void init(Context context) {
        if (TraceProperties.shouldStartWhenAppLaunch()) {
            this.startTracing(false);
        }
        this.tracingDirPath = context.getFilesDir().getAbsolutePath() + "/rhea/tracing/" + Process.myPid();
        Thread serverThread = new Thread(() -> HttpServer.start(context.getExternalFilesDir(null), this.tracingDirPath));
        serverThread.start();
    }

    public boolean startTracing(boolean async) {
        if (this.traceTokens != null) {
            Log.e((String)TAG, (String)"start failed: already started and not yet stopped");
            return false;
        }
        if (!TraceGlobal.init()) {
            Log.e((String)TAG, (String)"start failed: global dependency init failed");
            return false;
        }
        List<TraceMeta> traceMetas = this.requireTraceMetas();
        if (traceMetas.isEmpty()) {
            return false;
        }
        if (async) {
            Thread startThread = new Thread(() -> {
                List<TraceAbility<?>> traceAbilities = TraceAbilityCenter.getAbilities(traceMetas);
                long[] tokens = new long[traceMetas.size()];
                for (int i = 0; i < traceMetas.size(); ++i) {
                    tokens[i] = traceAbilities.get(i).start();
                }
                this.traceTokens = tokens;
            });
            startThread.start();
        } else {
            List<TraceAbility<?>> traceAbilities = TraceAbilityCenter.getAbilities(traceMetas);
            long[] tokens = new long[traceMetas.size()];
            for (int i = 0; i < traceMetas.size(); ++i) {
                tokens[i] = traceAbilities.get(i).start();
            }
            this.traceTokens = tokens;
        }
        return true;
    }

    public boolean stopTracing() {
        long[] startTokens = this.traceTokens;
        this.traceTokens = null;
        if (startTokens == null) {
            Log.e((String)TAG, (String)"stop failed: no start tokens");
            return false;
        }
        List<TraceMeta> traceMetas = this.requireTraceMetas();
        List<TraceAbility<?>> traceAbilities = TraceAbilityCenter.getAbilities(traceMetas);
        long[] endTokens = new long[traceMetas.size()];
        for (int i = 0; i < traceMetas.size(); ++i) {
            endTokens[i] = traceAbilities.get(i).stop();
        }
        HandlerThreadUtils.getCollectorThreadHandler().post(() -> {
            JSONObject extra = this.getExtra();
            String extraStr = extra == null ? "" : extra.toString();
            String path = this.getDumpPath();
            if (!this.makeDumpDir(path)) {
                Log.e((String)TAG, (String)("make dump dir failed: " + path));
                HttpServer.getServer().onTraceDumpFinished(-100, this.getDumpPath(), traceMetas, startTokens, endTokens);
                return;
            }
            for (int i = 0; i < traceMetas.size(); ++i) {
                long startToken = startTokens[i];
                long endToken = endTokens[i];
                TraceAbility ability = (TraceAbility)traceAbilities.get(i);
                int result = ability.dumpTokenRange(startToken, endToken, path, extraStr);
                if (result == 0) continue;
                Log.e((String)TAG, (String)("dumping failed for " + ((TraceMeta)((Object)((Object)traceMetas.get(i)))).getName() + ", error code is " + result));
            }
            HttpServer.getServer().onTraceDumpFinished(0, this.getDumpPath(), traceMetas, startTokens, endTokens);
        });
        return true;
    }

    public void clearAfterTracing() {
        File directory = new File(this.tracingDirPath);
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    file.delete();
                }
            }
            directory.delete();
        }
    }

    private List<TraceMeta> requireTraceMetas() {
        return Collections.singletonList(TraceMeta.Sampling);
    }

    private String getDumpPath() {
        File directory = new File(this.tracingDirPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return this.tracingDirPath;
    }

    private boolean makeDumpDir(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        File directory = new File(path);
        if (!directory.exists()) {
            return directory.mkdirs();
        }
        return directory.isDirectory();
    }

    private JSONObject getExtra() {
        try {
            JSONObject params = new JSONObject();
            params.put("processId", Process.myPid());
            return params;
        }
        catch (JSONException e) {
            return null;
        }
    }

    private static class Holder {
        @SuppressLint(value={"StaticFieldLeak"})
        private static final TraceManager INSTANCE = new TraceManager();

        private Holder() {
        }
    }
}

