/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.prop;

import java.lang.reflect.Method;

public class TraceProperties {
    private static final String KEY_TRACE_ON_LAUNCH = "debug.rhea3.startWhenAppLaunch";
    private static final String KEY_WAIT_TRACE_TIMEOUT = "debug.rhea3.waitTraceTimeout";
    private static final String KEY_BUFFER_SIZE = "debug.rhea3.methodIdMaxSize";
    private static final String KEY_SAMPLE_INTERVAL = "debug.rhea3.sampleInterval";
    private static final int DEFAULT_WAIT_TRACE_TIMEOUT_SECONDS = 20;

    public static boolean shouldStartWhenAppLaunch() {
        String startWhenAppLaunchStr = Fetcher.fetch(KEY_TRACE_ON_LAUNCH);
        if (startWhenAppLaunchStr == null) {
            return false;
        }
        return startWhenAppLaunchStr.equals("1");
    }

    public static int getWaitTraceTimeoutSeconds() {
        String timeoutStr = Fetcher.fetch(KEY_WAIT_TRACE_TIMEOUT);
        if (timeoutStr == null) {
            return 20;
        }
        try {
            return Integer.parseInt(timeoutStr);
        }
        catch (Exception e) {
            return 20;
        }
    }

    public static int getCoreBufferSize() {
        return TraceProperties.getCoreBufferSizeOrDefault(200000);
    }

    public static int getCoreBufferSizeOrDefault(int defaultSize) {
        String bufferSizeStr = Fetcher.fetch(KEY_BUFFER_SIZE);
        if (bufferSizeStr == null) {
            return defaultSize;
        }
        try {
            int bufferSize = Integer.parseInt(bufferSizeStr);
            return bufferSize > 0 ? bufferSize : defaultSize;
        }
        catch (Exception e) {
            return defaultSize;
        }
    }

    public static long getSampleIntervalOrDefault(long defaultIntervalNs) {
        String sampleIntervalStr = Fetcher.fetch(KEY_SAMPLE_INTERVAL);
        if (sampleIntervalStr == null) {
            return defaultIntervalNs;
        }
        try {
            long interval = Long.parseLong(sampleIntervalStr);
            if (interval > 0L) {
                return interval;
            }
        }
        catch (Exception e) {
            return defaultIntervalNs;
        }
        return defaultIntervalNs;
    }

    private static class Fetcher {
        private static Method sGetPropertiesMethod = null;

        private Fetcher() {
        }

        public static String fetch(String key) {
            String value = null;
            try {
                if (sGetPropertiesMethod == null) {
                    Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
                    sGetPropertiesMethod = systemPropertiesClass.getMethod("get", String.class);
                }
                value = (String)sGetPropertiesMethod.invoke(null, key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        }
    }
}

