/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.server;

import android.util.Log;
import com.bytedance.rheatrace.TraceManager;
import com.bytedance.rheatrace.prop.TraceProperties;
import com.bytedance.rheatrace.trace.base.TraceMeta;
import fi.iki.elonen.NanoHTTPD;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public final class HttpServer {
    private static final String TAG = "RheaServer";
    private static Server server = null;
    private static final String MINE_BIN = "application/octet-stream";

    public static Server getServer() {
        return server;
    }

    public static void start(File externalFileDir, String hostDirPath) {
        int waitTraceTimeoutSeconds = TraceProperties.getWaitTraceTimeoutSeconds();
        if (server != null && server.isAlive()) {
            Log.i((String)TAG, (String)("stop previous server on port " + server.getListeningPort()));
            server.stop();
        }
        server = new Server(new File(hostDirPath), waitTraceTimeoutSeconds);
        try {
            server.start();
            int port = server.getListeningPort();
            HttpServer.makePortDir(externalFileDir, port);
            Log.i((String)TAG, (String)("start new http server on port " + port));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void makePortDir(File externalFileDir, int port) {
        File[] ports;
        File portDir = new File(externalFileDir, "rhea-port");
        if (!portDir.exists()) {
            portDir.mkdirs();
        }
        if ((ports = portDir.listFiles()) == null || ports.length == 0) {
            File realPortDir = new File(portDir, String.valueOf(port));
            realPortDir.mkdirs();
        } else {
            ports[0].renameTo(new File(portDir, String.valueOf(port)));
        }
    }

    public static class Server
    extends NanoHTTPD {
        private final File hostDir;
        private final int waitTraceTimeoutSeconds;
        private boolean dataFlushFinished = false;
        private String error = null;
        private JSONObject traceDebugInfo = null;

        public Server(File hostDir, int waitTraceTimeoutSeconds) {
            super(0);
            this.hostDir = hostDir;
            this.waitTraceTimeoutSeconds = waitTraceTimeoutSeconds;
        }

        public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
            try {
                String action = (String)session.getParms().get("action");
                if (action == null) {
                    return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)"no action provided");
                }
                String name = (String)session.getParms().get("name");
                Log.i((String)HttpServer.TAG, (String)("action=" + action + ", name=" + name));
                switch (action) {
                    case "start": {
                        TraceManager.getInstance().startTracing(true);
                        this.dataFlushFinished = false;
                        this.error = null;
                        this.traceDebugInfo = null;
                        Log.i((String)HttpServer.TAG, (String)"rhea trace started");
                        return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"start trace");
                    }
                    case "stop": {
                        TraceManager.getInstance().stopTracing();
                        Log.i((String)HttpServer.TAG, (String)"rhea trace stopped");
                        return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"stop trace");
                    }
                    case "clean": {
                        TraceManager.getInstance().clearAfterTracing();
                        return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)"clear trace");
                    }
                    case "query": {
                        if (name == null) {
                            return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)("no name provided for action " + action));
                        }
                        String queryResult = this.query(name);
                        if (queryResult == null) {
                            return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)("no result for action " + action + " name " + name));
                        }
                        return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)queryResult);
                    }
                    case "download": {
                        if (!this.waitForDataReady()) {
                            this.error = "wait for trace ready timeout";
                            return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)this.error);
                        }
                        if (name == null) {
                            return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)("no name provided for action " + action));
                        }
                        File file = new File(this.hostDir, name);
                        if (!file.exists()) {
                            this.error = "trace file not exists: " + file.getAbsolutePath();
                            return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)this.error);
                        }
                        return Server.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)HttpServer.MINE_BIN, (InputStream)new FileInputStream(file));
                    }
                }
                return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)("unknown action " + action));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private String query(String name) {
            switch (name) {
                case "error": {
                    if (this.error != null) {
                        return this.error;
                    }
                    return "no error";
                }
                case "debug": {
                    if (this.traceDebugInfo != null) {
                        return this.traceDebugInfo.toString();
                    }
                    return "";
                }
            }
            return null;
        }

        public void onTraceDumpFinished(int code, String path, List<TraceMeta> traceMetas, long[] startTokens, long[] endTokens) {
            if (code != 0) {
                this.error = "dump trace failed, error code is " + code;
            }
            this.dataFlushFinished = true;
            JSONObject debugInfo = new JSONObject();
            for (int i = 0; i < traceMetas.size(); ++i) {
                TraceMeta meta = traceMetas.get(i);
                JSONObject metaJson = new JSONObject();
                try {
                    metaJson.put("start", startTokens[i]);
                    metaJson.put("end", endTokens[i]);
                    if (meta.isCore()) {
                        metaJson.put("capacity", TraceProperties.getCoreBufferSize());
                    }
                    debugInfo.put(meta.getName(), (Object)metaJson);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            this.traceDebugInfo = debugInfo;
        }

        private boolean waitForDataReady() {
            for (int i = 0; i < this.waitTraceTimeoutSeconds; ++i) {
                if (this.dataFlushFinished) {
                    return true;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }
    }
}

