/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.trace.base;

import androidx.annotation.NonNull;
import com.bytedance.rheatrace.trace.TraceConfigurations;
import com.bytedance.rheatrace.trace.base.TraceConfig;
import com.bytedance.rheatrace.trace.base.TraceMeta;

public abstract class TraceAbility<T extends TraceConfig> {
    private int activeCount = 0;
    private long nativeCollectorPtr = 0L;

    public synchronized long start() {
        if (this.activeCount++ == 0) {
            if (this.nativeCollectorPtr == 0L) {
                this.nativeCollectorPtr = this.nativeCreate(this.getMeta().getOffset(), this.getDeflatedConfigs());
            }
            this.nativeStart(this.nativeCollectorPtr, this.getExtraStartConfig());
        } else {
            this.nativeUpdateConfig(this.nativeCollectorPtr, this.getDeflatedUpdatableConfigs());
        }
        return this.nativeMark(this.nativeCollectorPtr);
    }

    public synchronized long stop() {
        long result = this.nativeMark(this.nativeCollectorPtr);
        if (--this.activeCount == 0) {
            this.nativeStop(this.nativeCollectorPtr);
        }
        return result;
    }

    public int dumpTokenRange(long start, long end, String path, String extra) {
        TraceMeta meta = this.getMeta();
        if (meta.isCore()) {
            return this.nativeDumpTokenRange(this.nativeCollectorPtr, start, end, path, extra);
        }
        return this.nativeDumpTokenRange(this.nativeCollectorPtr, start, end, path, null);
    }

    @NonNull
    protected abstract TraceMeta getMeta();

    protected abstract long[] getExtraStartConfig();

    private long[] getDeflatedConfigs() {
        Object config = TraceConfigurations.getConfig(this.getMeta());
        if (config != null) {
            return ((TraceConfig)config).deflate();
        }
        return new long[0];
    }

    private long[] getDeflatedUpdatableConfigs() {
        TraceMeta meta = this.getMeta();
        Object config = TraceConfigurations.getConfig(meta);
        if (config == null) {
            throw new RuntimeException(meta.getName() + " has no config");
        }
        return ((TraceConfig)config).deflateUpdatable();
    }

    private native long nativeCreate(int var1, long[] var2);

    private native void nativeStart(long var1, long[] var3);

    private native void nativeUpdateConfig(long var1, long[] var3);

    private native long nativeMark(long var1);

    private native int nativeDumpTokenRange(long var1, long var3, long var5, String var7, String var8);

    private native void nativeStop(long var1);
}

