/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.trace.sampling;

import com.bytedance.rheatrace.trace.base.TraceConfig;
import com.bytedance.rheatrace.trace.sampling.SamplingConfigCreator;

public class SamplingConfig
extends TraceConfig {
    public static final int OFFLINE_BUFFER_SIZE_DEFAULT = 200000;
    public static final long OFFLINE_JAVA_SAMPLE_INTERVAL_DEFAULT = 1000000L;
    private int bufferSize;
    private long mainThreadIntervalNs;
    private long otherThreadIntervalNs;
    private int clockType;
    private int stackWalkKind;
    private boolean disableObjectAllocation;
    private boolean enableRusage;
    private boolean enableWakeup;
    private boolean enableThreadNames;
    private boolean shadowPause;

    public SamplingConfig(SamplingConfigCreator creator) {
        super(creator);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public long getMainThreadIntervalNs() {
        return this.mainThreadIntervalNs;
    }

    public void setMainThreadIntervalNs(long mainThreadIntervalNs) {
        this.mainThreadIntervalNs = mainThreadIntervalNs;
    }

    public long getOtherThreadIntervalNs() {
        return this.otherThreadIntervalNs;
    }

    public void setOtherThreadIntervalNs(long otherThreadIntervalNs) {
        this.otherThreadIntervalNs = otherThreadIntervalNs;
    }

    public int getClockType() {
        return this.clockType;
    }

    public void setClockType(int clockType) {
        this.clockType = clockType;
    }

    public int getStackWalkKind() {
        return this.stackWalkKind;
    }

    public void setStackWalkKind(int stackWalkKind) {
        this.stackWalkKind = stackWalkKind;
    }

    public boolean isDisableObjectAllocation() {
        return this.disableObjectAllocation;
    }

    public void setDisableObjectAllocation(boolean disableObjectAllocation) {
        this.disableObjectAllocation = disableObjectAllocation;
    }

    public boolean isEnableRusage() {
        return this.enableRusage;
    }

    public void setEnableRusage(boolean enableRusage) {
        this.enableRusage = enableRusage;
    }

    public boolean isEnableWakeup() {
        return this.enableWakeup;
    }

    public void setEnableWakeup(boolean enableWakeup) {
        this.enableWakeup = enableWakeup;
    }

    public boolean isEnableThreadNames() {
        return this.enableThreadNames;
    }

    public void setEnableThreadNames(boolean enableThreadNames) {
        this.enableThreadNames = enableThreadNames;
    }

    public boolean isShadowPause() {
        return this.shadowPause;
    }

    public void setShadowPause(boolean shadowPause) {
        this.shadowPause = shadowPause;
    }

    @Override
    public long[] deflate() {
        long[] results = new long[]{this.bufferSize, this.mainThreadIntervalNs, this.otherThreadIntervalNs, this.clockType, this.stackWalkKind, this.disableObjectAllocation ? 0L : 1L, this.enableRusage ? 1L : 0L, this.enableWakeup ? 1L : 0L, this.enableThreadNames ? 1L : 0L, this.shadowPause ? 1L : 0L};
        return results;
    }

    @Override
    public long[] deflateUpdatable() {
        long[] results = new long[]{this.mainThreadIntervalNs, this.otherThreadIntervalNs};
        return results;
    }
}

