/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.trace.sampling;

import com.bytedance.rheatrace.prop.TraceProperties;
import com.bytedance.rheatrace.trace.base.TraceConfigCreator;
import com.bytedance.rheatrace.trace.sampling.SamplingConfig;

public class SamplingConfigCreator
implements TraceConfigCreator<SamplingConfig> {
    @Override
    public SamplingConfig create() {
        SamplingConfig config = new SamplingConfig(this);
        config.setBufferSize(TraceProperties.getCoreBufferSizeOrDefault(200000));
        long intervalNs = TraceProperties.getSampleIntervalOrDefault(1000000L);
        config.setMainThreadIntervalNs(intervalNs);
        config.setOtherThreadIntervalNs(intervalNs);
        config.setClockType(2);
        config.setStackWalkKind(0);
        config.setEnableRusage(true);
        config.setDisableObjectAllocation(false);
        config.setEnableWakeup(true);
        config.setEnableThreadNames(true);
        config.setShadowPause(true);
        return config;
    }

    @Override
    public void update(SamplingConfig config) {
        long intervalNs = TraceProperties.getSampleIntervalOrDefault(1000000L);
        config.setMainThreadIntervalNs(intervalNs);
        config.setOtherThreadIntervalNs(intervalNs);
    }
}

