/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.trace.sampling;

import androidx.annotation.NonNull;
import com.bytedance.rheatrace.trace.base.TraceAbility;
import com.bytedance.rheatrace.trace.base.TraceMeta;
import com.bytedance.rheatrace.trace.sampling.SamplingConfig;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class SamplingTrace
extends TraceAbility<SamplingConfig> {
    private long[] startConfigs = null;

    @Override
    @NonNull
    protected TraceMeta getMeta() {
        return TraceMeta.Sampling;
    }

    @Override
    protected long[] getExtraStartConfig() {
        if (this.startConfigs == null) {
            Class<?> unsafeClass2;
            long[] configArray = new long[7];
            configArray[0] = SamplingTrace.isNativeMethod(Object.class, "wait", Long.TYPE, Integer.TYPE) ? 1L : 0L;
            try {
                unsafeClass2 = Class.forName("sun.misc.Unsafe");
                configArray[1] = SamplingTrace.isNativeMethod(unsafeClass2, "park", Boolean.TYPE, Long.TYPE) ? 1L : 0L;
                configArray[2] = SamplingTrace.isNativeMethod(unsafeClass2, "unpark", Object.class) ? 1L : 0L;
            }
            catch (Exception unsafeClass2) {
                // empty catch block
            }
            try {
                unsafeClass2 = Class.forName("jdk.internal.misc.Unsafe");
                configArray[3] = SamplingTrace.isNativeMethod(unsafeClass2, "park", Boolean.TYPE, Long.TYPE) ? 1L : 0L;
                configArray[4] = SamplingTrace.isNativeMethod(unsafeClass2, "unpark", Object.class) ? 1L : 0L;
            }
            catch (Exception exception) {
                // empty catch block
            }
            configArray[5] = SamplingTrace.isNativeMethod(Object.class, "notify", new Class[0]) ? 1L : 0L;
            configArray[6] = SamplingTrace.isNativeMethod(Object.class, "notifyAll", new Class[0]) ? 1L : 0L;
            this.startConfigs = configArray;
        }
        return this.startConfigs;
    }

    private static boolean isNativeMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getMethod(name, parameterTypes);
            return Modifier.isNative(method.getModifiers());
        }
        catch (Exception e) {
            return false;
        }
    }
}

