/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.utils;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;

public class ProcessUtils {
    private static volatile String sProcessName;

    public static boolean isMainProcess(Context context) {
        return context.getPackageName().equals(ProcessUtils.getProcessName(context));
    }

    private static String getProcessName(Context context) {
        if (sProcessName != null) {
            return sProcessName;
        }
        String processName = null;
        if (Build.VERSION.SDK_INT >= 28) {
            processName = Application.getProcessName();
        }
        if (TextUtils.isEmpty((CharSequence)processName)) {
            try {
                processName = ProcessUtils.getProcessNameClassical(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (TextUtils.isEmpty((CharSequence)processName)) {
            processName = ProcessUtils.getProcessNameSecure();
        }
        sProcessName = processName;
        return processName;
    }

    private static String getProcessNameClassical(Context context) {
        String processName = "";
        int pid = Process.myPid();
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        if (manager == null) {
            return processName;
        }
        List appProcessList = manager.getRunningAppProcesses();
        if (appProcessList == null) {
            return processName;
        }
        for (ActivityManager.RunningAppProcessInfo process : appProcessList) {
            if (process.pid != pid) continue;
            processName = process.processName;
        }
        return processName;
    }

    private static String getProcessNameSecure() {
        String processName = "";
        try {
            File file = new File("/proc/" + Process.myPid() + "/cmdline");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            processName = bufferedReader.readLine().trim();
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return processName;
    }
}

