/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.precise;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.BaseVariant;
import com.bytedance.rheatrace.common.retrace.MappingCollector;
import com.bytedance.rheatrace.common.retrace.MappingProcessor;
import com.bytedance.rheatrace.common.retrace.MappingReader;
import com.bytedance.rheatrace.precise.PreciseInstrumentationContext;
import com.bytedance.rheatrace.precise.extension.PreciseInstrumentationExtension;
import com.bytedance.rheatrace.precise.method.EvilMethodDetector;
import com.bytedance.rheatrace.precise.method.EvilMethodInfo;
import com.bytedance.rheatrace.precise.method.EvilRootMethodDetector;
import com.bytedance.rheatrace.precise.method.MethodHelper;
import com.google.common.base.Joiner;
import com.ss.android.ugc.bytex.common.BaseContext;
import com.ss.android.ugc.bytex.common.BaseExtension;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u001aH\u0016J\b\u0010\"\u001a\u00020\u001aH\u0002J\b\u0010#\u001a\u00020\u001aH\u0016J\u000e\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/bytedance/rheatrace/precise/PreciseInstrumentationContext;", "Lcom/ss/android/ugc/bytex/common/BaseContext;", "Lcom/bytedance/rheatrace/precise/extension/PreciseInstrumentationExtension;", "project", "Lorg/gradle/api/Project;", "android", "Lcom/android/build/gradle/AppExtension;", "extension", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/AppExtension;Lcom/bytedance/rheatrace/precise/extension/PreciseInstrumentationExtension;)V", "evilMethodDetector", "Lcom/bytedance/rheatrace/precise/method/EvilMethodDetector;", "evilRootMethodDetector", "Lcom/bytedance/rheatrace/precise/method/EvilRootMethodDetector;", "getEvilRootMethodDetector", "()Lcom/bytedance/rheatrace/precise/method/EvilRootMethodDetector;", "setEvilRootMethodDetector", "(Lcom/bytedance/rheatrace/precise/method/EvilRootMethodDetector;)V", "mappingCollector", "Lcom/bytedance/rheatrace/common/retrace/MappingCollector;", "getMappingCollector", "()Lcom/bytedance/rheatrace/common/retrace/MappingCollector;", "setMappingCollector", "(Lcom/bytedance/rheatrace/common/retrace/MappingCollector;)V", "methodHelper", "Lcom/bytedance/rheatrace/precise/method/MethodHelper;", "beforeTransform", "", "changeRheaFilter", "evilMethodList", "", "Lcom/bytedance/rheatrace/precise/method/EvilMethodInfo;", "getMappingDir", "", "init", "initMappingCollector", "releaseContext", "traverse", "node", "Lorg/objectweb/asm/tree/ClassNode;", "rhea-precise-instrumentation"})
public final class PreciseInstrumentationContext
extends BaseContext<PreciseInstrumentationExtension> {
    private MethodHelper methodHelper;
    private EvilMethodDetector evilMethodDetector;
    @NotNull
    public EvilRootMethodDetector evilRootMethodDetector;
    @Nullable
    private MappingCollector mappingCollector;

    @NotNull
    public final EvilRootMethodDetector getEvilRootMethodDetector() {
        EvilRootMethodDetector evilRootMethodDetector = this.evilRootMethodDetector;
        if (evilRootMethodDetector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"evilRootMethodDetector");
        }
        return evilRootMethodDetector;
    }

    public final void setEvilRootMethodDetector(@NotNull EvilRootMethodDetector evilRootMethodDetector) {
        Intrinsics.checkParameterIsNotNull((Object)evilRootMethodDetector, (String)"<set-?>");
        this.evilRootMethodDetector = evilRootMethodDetector;
    }

    @Nullable
    public final MappingCollector getMappingCollector() {
        return this.mappingCollector;
    }

    public final void setMappingCollector(@Nullable MappingCollector mappingCollector) {
        this.mappingCollector = mappingCollector;
    }

    public void init() {
        this.initMappingCollector();
        this.methodHelper = new MethodHelper(this);
        this.evilRootMethodDetector = new EvilRootMethodDetector();
        MethodHelper methodHelper = this.methodHelper;
        if (methodHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"methodHelper");
        }
        EvilRootMethodDetector evilRootMethodDetector = this.evilRootMethodDetector;
        if (evilRootMethodDetector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"evilRootMethodDetector");
        }
        this.evilMethodDetector = new EvilMethodDetector(methodHelper, evilRootMethodDetector);
    }

    private final void initMappingCollector() {
        if (this.mappingCollector != null) {
            return;
        }
        this.mappingCollector = new MappingCollector();
        File mappingFile = new File(this.getMappingDir(), "mapping.txt");
        if (mappingFile.isFile()) {
            MappingReader mappingReader = new MappingReader(mappingFile);
            MappingCollector mappingCollector = this.mappingCollector;
            if (mappingCollector == null) {
                Intrinsics.throwNpe();
            }
            mappingReader.read((MappingProcessor)mappingCollector);
        }
    }

    private final String getMappingDir() {
        String string;
        TransformContext transformContext = this.getTransformContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)transformContext, (String)"transformContext");
        BaseVariant baseVariant = transformContext.getVariant();
        Intrinsics.checkExpressionValueIsNotNull((Object)baseVariant, (String)"transformContext.variant");
        if (baseVariant.getBuildType().isMinifyEnabled()) {
            TransformContext transformContext2 = this.getTransformContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)transformContext2, (String)"transformContext");
            BaseVariant baseVariant2 = transformContext2.getVariant();
            Intrinsics.checkExpressionValueIsNotNull((Object)baseVariant2, (String)"transformContext.variant");
            File file = baseVariant2.getMappingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"transformContext.variant.mappingFile");
            String string2 = file.getParent();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"transformContext.variant.mappingFile.parent");
        } else {
            Joiner joiner = Joiner.on((char)File.separatorChar);
            Project project = this.project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            File file = project.getBuildDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.buildDir");
            String string3 = file.getAbsolutePath();
            Object[] objectArray = new Object[2];
            objectArray[0] = "mapping";
            TransformContext transformContext3 = this.getTransformContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)transformContext3, (String)"transformContext");
            objectArray[1] = transformContext3.getVariantName();
            String string4 = joiner.join((Object)string3, (Object)"outputs", objectArray);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"Joiner.on(File.separator\u2026variantName\n            )");
        }
        return string;
    }

    public final void traverse(@NotNull ClassNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        EvilRootMethodDetector evilRootMethodDetector = this.evilRootMethodDetector;
        if (evilRootMethodDetector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"evilRootMethodDetector");
        }
        evilRootMethodDetector.collect(node);
        EvilMethodDetector evilMethodDetector = this.evilMethodDetector;
        if (evilMethodDetector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"evilMethodDetector");
        }
        evilMethodDetector.collect(node);
    }

    public final void beforeTransform() {
        EvilMethodDetector evilMethodDetector = this.evilMethodDetector;
        if (evilMethodDetector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"evilMethodDetector");
        }
        List<EvilMethodInfo> list = evilMethodDetector.findEvilMethods();
        boolean bl = false;
        boolean bl2 = false;
        List<EvilMethodInfo> $this$apply = list;
        boolean bl3 = false;
        this.changeRheaFilter($this$apply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void changeRheaFilter(List<EvilMethodInfo> evilMethodList) {
        CharSequence charSequence = ((PreciseInstrumentationExtension)this.extension).getTraceFilter();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            throw (Throwable)new Exception("evil method: rheaTraceFilter isNullOrEmpty");
        }
        bl = false;
        HashMap evilMethodMap = new HashMap();
        Iterable $this$forEach$iv = evilMethodList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EvilMethodInfo evilMethodInfo = (EvilMethodInfo)element$iv;
            boolean bl3 = false;
            ((ArrayList)evilMethodMap.computeIfAbsent(evilMethodInfo.getClassName(), changeRheaFilter.1.1.INSTANCE)).add(evilMethodInfo);
        }
        String string = ((PreciseInstrumentationExtension)this.extension).getTraceFilter();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Closeable closeable = new FileWriter(string, true);
        bl2 = false;
        Object object = null;
        try {
            FileWriter writer = (FileWriter)closeable;
            boolean bl4 = false;
            writer.write("\n");
            Map $this$forEach$iv2 = evilMethodMap;
            boolean $i$f$forEach2 = false;
            Map map = $this$forEach$iv2;
            boolean bl5 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry element$iv;
                Map.Entry $dstr$key$list = element$iv = iterator.next();
                boolean bl6 = false;
                Map.Entry entry = $dstr$key$list;
                boolean bl7 = false;
                String string2 = (String)entry.getKey();
                entry = $dstr$key$list;
                bl7 = false;
                ArrayList list = (ArrayList)entry.getValue();
                writer.write("\n");
                String className = StringsKt.replace$default((String)key, (String)"/", (String)".", (boolean)false, (int)4, null);
                writer.write("-traceclassmethods " + className + " {\n");
                Iterable $this$forEach$iv3 = list;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    EvilMethodInfo it = (EvilMethodInfo)element$iv2;
                    boolean bl8 = false;
                    writer.write("   " + it.getMethodName() + ' ' + it.getDesc() + '\n');
                }
                writer.write("}\n");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    public void releaseContext() {
        super.releaseContext();
        MappingCollector mappingCollector = this.mappingCollector;
        if (mappingCollector != null) {
            mappingCollector.release();
        }
        EvilRootMethodDetector evilRootMethodDetector = this.evilRootMethodDetector;
        if (evilRootMethodDetector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"evilRootMethodDetector");
        }
        evilRootMethodDetector.release();
        EvilMethodDetector evilMethodDetector = this.evilMethodDetector;
        if (evilMethodDetector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"evilMethodDetector");
        }
        evilMethodDetector.release();
        MethodHelper methodHelper = this.methodHelper;
        if (methodHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"methodHelper");
        }
        methodHelper.release();
    }

    public PreciseInstrumentationContext(@NotNull Project project, @NotNull AppExtension android, @NotNull PreciseInstrumentationExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)android, (String)"android");
        Intrinsics.checkParameterIsNotNull((Object)((Object)extension), (String)"extension");
        super(project, android, (BaseExtension)extension);
    }
}

