/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.precise.method;

import com.bytedance.rheatrace.common.retrace.MappingCollector;
import com.bytedance.rheatrace.common.retrace.MethodInfo;
import com.bytedance.rheatrace.common.utils.ClassToJavaFormat;
import com.bytedance.rheatrace.precise.PreciseInstrumentationContext;
import com.bytedance.rheatrace.precise.method.EvilRootMethodDetector;
import com.bytedance.rheatrace.precise.method.MethodFilter;
import com.bytedance.rheatrace.precise.method.MethodMatcher;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u001e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0007J\u0016\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007J\u0006\u0010!\u001a\u00020\u000eR6\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/bytedance/rheatrace/precise/method/MethodHelper;", "", "preciseInstrContext", "Lcom/bytedance/rheatrace/precise/PreciseInstrumentationContext;", "(Lcom/bytedance/rheatrace/precise/PreciseInstrumentationContext;)V", "evilRootMethods", "Ljava/util/HashMap;", "", "", "Lcom/bytedance/rheatrace/precise/method/MethodMatcher;", "Lkotlin/collections/HashMap;", "methodFilter", "Lcom/bytedance/rheatrace/precise/method/MethodFilter;", "addDefaultEvilRootMethod", "", "addEvilRootMethod", "method", "getOriginMethodName", "className", "methodName", "methodDesc", "isTraceAnnotation", "", "desc", "isTraceClass", "isTraceMethod", "originFullMethod", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "matchEvilRootMethod", "", "owner", "name", "release", "rhea-precise-instrumentation"})
public final class MethodHelper {
    private MethodFilter methodFilter;
    private final HashMap<String, List<MethodMatcher>> evilRootMethods;
    private final PreciseInstrumentationContext preciseInstrContext;

    private final void addDefaultEvilRootMethod() {
        if (!MethodFilter.Companion.getDefaultPreciseInstrEnable()) {
            return;
        }
        InputStream inputStream = MethodHelper.class.getClassLoader().getResourceAsStream("framework_evil_method.txt");
        if (inputStream == null) {
            return;
        }
        InputStream inputStream2 = inputStream;
        TextStreamsKt.forEachLine((Reader)new BufferedReader(new InputStreamReader(inputStream2, Charsets.UTF_8)), (Function1)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ MethodHelper this$0;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                MappingCollector mappingCollector = MethodHelper.access$getPreciseInstrContext$p(this.this$0).getMappingCollector();
                if (mappingCollector == null) {
                    Intrinsics.throwNpe();
                }
                MethodInfo obfuscatedMethod = mappingCollector.obfuscatedInfoWithoutDesc(StringsKt.replace$default((String)((String)StringsKt.split$default((CharSequence)it, (String[])new String[]{"#"}, (boolean)false, (int)0, (int)6, null).get(0)), (String)"/", (String)".", (boolean)false, (int)4, null), (String)StringsKt.split$default((CharSequence)it, (String[])new String[]{"#"}, (boolean)false, (int)0, (int)6, null).get(1));
                String obfuscatedClassName = StringsKt.replace$default((String)obfuscatedMethod.getOriginalClassName(), (String)".", (String)"/", (boolean)false, (int)4, null);
                String obfuscatedMethodName = StringsKt.replace$default((String)obfuscatedMethod.getOriginalName(), (String)".", (String)"/", (boolean)false, (int)4, null);
                MethodHelper.access$addEvilRootMethod(this.this$0, obfuscatedClassName + '#' + obfuscatedMethodName);
            }
            {
                this.this$0 = methodHelper;
                super(1);
            }
        }));
    }

    private final void addEvilRootMethod(String method) {
        String key = (String)StringsKt.split$default((CharSequence)method, (String[])new String[]{"#"}, (boolean)false, (int)0, (int)6, null).get(0);
        if (!this.evilRootMethods.containsKey(key)) {
            ((Map)this.evilRootMethods).put(key, new LinkedList());
        }
        List<MethodMatcher> list = this.evilRootMethods.get(key);
        if (list == null) {
            Intrinsics.throwNpe();
        }
        list.add(new MethodMatcher(method));
    }

    public final int matchEvilRootMethod(@NotNull String owner, @NotNull String name, @NotNull String desc) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        LinkedList matcherList = new LinkedList();
        if (this.evilRootMethods.size() != 0 && this.evilRootMethods.get(owner) != null) {
            List<MethodMatcher> list = this.evilRootMethods.get(owner);
            if (list == null) {
                Intrinsics.throwNpe();
            }
            matcherList.addAll(list);
        }
        for (MethodMatcher matcher : matcherList) {
            if (!matcher.match(owner, name, desc)) continue;
            return 8;
        }
        EvilRootMethodDetector.RootMethodNodeInfo evilRootMethod = this.preciseInstrContext.getEvilRootMethodDetector().marchEvilRootMethod(owner, name, desc);
        if (evilRootMethod != null) {
            return evilRootMethod.getMethodType();
        }
        return 0;
    }

    @NotNull
    public final String getOriginMethodName(@NotNull String className, @NotNull String methodName, @NotNull String methodDesc) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        Intrinsics.checkParameterIsNotNull((Object)methodDesc, (String)"methodDesc");
        MappingCollector mappingCollector = this.preciseInstrContext.getMappingCollector();
        if (mappingCollector == null) {
            Intrinsics.throwNpe();
        }
        MethodInfo methodInfo = mappingCollector.originalMethodInfo(StringsKt.replace$default((String)className, (String)"/", (String)".", (boolean)false, (int)4, null), methodName, methodDesc);
        return methodInfo.getFullMethodName();
    }

    public final boolean isTraceMethod(@NotNull String originFullMethod, @NotNull ClassNode classNode) {
        Intrinsics.checkParameterIsNotNull((Object)originFullMethod, (String)"originFullMethod");
        Intrinsics.checkParameterIsNotNull((Object)classNode, (String)"classNode");
        return this.methodFilter.isTraceMethod(originFullMethod, classNode);
    }

    public final boolean isTraceAnnotation(@NotNull String desc) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        String proguardClassName = ClassToJavaFormat.INSTANCE.parseDesc(desc, "");
        MappingCollector mappingCollector = this.preciseInstrContext.getMappingCollector();
        if (mappingCollector == null) {
            Intrinsics.throwNpe();
        }
        String originAnnotationClassName = mappingCollector.originalClassName(proguardClassName, proguardClassName);
        return this.methodFilter.isTraceAnnotation(originAnnotationClassName);
    }

    public final boolean isTraceClass(@NotNull String className) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        MappingCollector mappingCollector = this.preciseInstrContext.getMappingCollector();
        if (mappingCollector == null) {
            Intrinsics.throwNpe();
        }
        String originClassName = mappingCollector.originalClassName(className, className);
        return this.methodFilter.isTraceClass(originClassName);
    }

    public final void release() {
        this.evilRootMethods.clear();
    }

    public MethodHelper(@NotNull PreciseInstrumentationContext preciseInstrContext) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)preciseInstrContext), (String)"preciseInstrContext");
        this.preciseInstrContext = preciseInstrContext;
        this.methodFilter = new MethodFilter(this.preciseInstrContext);
        this.evilRootMethods = new HashMap();
        this.methodFilter.parseTraceFilterFile();
        this.addDefaultEvilRootMethod();
        Iterable $this$forEach$iv = this.methodFilter.getEvilRootMethods();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.addEvilRootMethod(it);
        }
    }

    public static final /* synthetic */ PreciseInstrumentationContext access$getPreciseInstrContext$p(MethodHelper $this) {
        return $this.preciseInstrContext;
    }

    public static final /* synthetic */ void access$addEvilRootMethod(MethodHelper $this, String method) {
        $this.addEvilRootMethod(method);
    }
}

