/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.precise.method;

import com.bytedance.rheatrace.common.utils.TypeUtil;
import com.bytedance.rheatrace.precise.method.MethodFilter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ$\u0010\u000b\u001a\b\u0018\u00010\u0006R\u00020\u00002\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0006\u0010\u0013\u001a\u00020\bR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006R\u00020\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/bytedance/rheatrace/precise/method/EvilRootMethodDetector;", "", "()V", "evilRootMethods", "", "", "Lcom/bytedance/rheatrace/precise/method/EvilRootMethodDetector$RootMethodNodeInfo;", "collect", "", "node", "Lorg/objectweb/asm/tree/ClassNode;", "marchEvilRootMethod", "owner", "name", "desc", "methodId", "className", "methodName", "methodDesc", "release", "RootMethodNodeInfo", "rhea-precise-instrumentation"})
public final class EvilRootMethodDetector {
    private final Map<String, RootMethodNodeInfo> evilRootMethods;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void collect(@NotNull ClassNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        List list = node.methods;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"node.methods");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MethodNode it = (MethodNode)element$iv;
            boolean bl = false;
            MethodNode methodNode = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)methodNode, (String)"it");
            RootMethodNodeInfo rootMethodNodeInfo = new RootMethodNodeInfo(node, methodNode);
            boolean bl2 = false;
            boolean bl3 = false;
            RootMethodNodeInfo $this$apply = rootMethodNodeInfo;
            boolean bl4 = false;
            Map<String, RootMethodNodeInfo> map = this.evilRootMethods;
            boolean bl5 = false;
            boolean bl6 = false;
            synchronized (map) {
                boolean bl7 = false;
                $this$apply.detectEvilRootMethod();
                if ($this$apply.getMethodType() > 0) {
                    this.evilRootMethods.put(this.methodId($this$apply.getClassName(), $this$apply.getMethodName(), $this$apply.getMethodDesc()), $this$apply);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Nullable
    public final RootMethodNodeInfo marchEvilRootMethod(@NotNull String owner, @NotNull String name, @NotNull String desc) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        return this.evilRootMethods.get(this.methodId(owner, name, desc));
    }

    private final String methodId(String className, String methodName, String methodDesc) {
        return className + '.' + methodName + methodDesc;
    }

    public final void release() {
        this.evilRootMethods.clear();
    }

    public EvilRootMethodDetector() {
        Map map;
        EvilRootMethodDetector evilRootMethodDetector = this;
        boolean bl = false;
        evilRootMethodDetector.evilRootMethods = map = (Map)new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\bH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lcom/bytedance/rheatrace/precise/method/EvilRootMethodDetector$RootMethodNodeInfo;", "", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "methodNode", "Lorg/objectweb/asm/tree/MethodNode;", "(Lcom/bytedance/rheatrace/precise/method/EvilRootMethodDetector;Lorg/objectweb/asm/tree/ClassNode;Lorg/objectweb/asm/tree/MethodNode;)V", "className", "", "getClassName", "()Ljava/lang/String;", "isAidlClass", "", "isNative", "methodDesc", "getMethodDesc", "methodName", "getMethodName", "methodType", "", "getMethodType", "()I", "setMethodType", "(I)V", "detectEvilRootMethod", "", "toString", "rhea-precise-instrumentation"})
    public final class RootMethodNodeInfo {
        private int methodType;
        @NotNull
        private final String className;
        @NotNull
        private final String methodName;
        @NotNull
        private final String methodDesc;
        private final boolean isAidlClass;
        private final boolean isNative;

        public final int getMethodType() {
            return this.methodType;
        }

        public final void setMethodType(int n) {
            this.methodType = n;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final String getMethodName() {
            return this.methodName;
        }

        @NotNull
        public final String getMethodDesc() {
            return this.methodDesc;
        }

        public final void detectEvilRootMethod() {
            if (MethodFilter.Companion.isAIDLEnable() && this.isAidlClass) {
                this.methodType = 16;
                return;
            }
            if (MethodFilter.Companion.isNativeEnable() && this.isNative) {
                this.methodType |= 1;
            }
        }

        @NotNull
        public String toString() {
            return "RootMethodNodeInfo(className='" + this.className + "', methodName='" + this.methodName + "', methodDesc='" + this.methodDesc + "')";
        }

        public RootMethodNodeInfo(@NotNull ClassNode classNode, MethodNode methodNode) {
            Intrinsics.checkParameterIsNotNull((Object)classNode, (String)"classNode");
            Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
            String string = classNode.name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classNode.name");
            this.className = string;
            String string2 = methodNode.name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"methodNode.name");
            this.methodName = string2;
            String string3 = methodNode.desc;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"methodNode.desc");
            this.methodDesc = string3;
            this.isAidlClass = classNode.interfaces.contains("android/os/IInterface");
            this.isNative = TypeUtil.isNative((int)methodNode.access);
        }
    }
}

