/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.android.bytehook;

import com.bytedance.android.bytehook.ILibLoader;
import com.bytedance.shadowhook.ShadowHook;

public class ByteHook {
    private static final int ERRNO_OK = 0;
    private static final int ERRNO_UNINIT = 1;
    private static final int ERRNO_LOAD_LIBRARY_EXCEPTION = 100;
    private static final int ERRNO_INIT_EXCEPTION = 101;
    private static boolean inited = false;
    private static int initStatus = 1;
    private static long initCostMs = -1L;
    private static final String libName = "bytehook";
    private static final ILibLoader defaultLibLoader = null;
    private static final int defaultMode = Mode.AUTOMATIC.getValue();
    private static final boolean defaultDebug = false;
    private static final boolean defaultRecordable = false;
    private static final ShadowHook.ILibLoader defaultShadowhookLibLoader = null;
    private static final ShadowHook.Mode defaultShadowhookMode = ShadowHook.Mode.SHARED;
    private static final boolean defaultShadowhookDebug = false;
    private static final boolean defaultShadowhookRecordable = false;
    private static final int recordItemAll = 255;
    private static final int recordItemTimestamp = 1;
    private static final int recordItemCallerLibName = 2;
    private static final int recordItemOp = 4;
    private static final int recordItemLibName = 8;
    private static final int recordItemSymName = 16;
    private static final int recordItemNewAddr = 32;
    private static final int recordItemErrno = 64;
    private static final int recordItemStub = 128;

    public static String getVersion() {
        return ByteHook.nativeGetVersion();
    }

    public static int init() {
        return ByteHook.init(null);
    }

    public static synchronized int init(Config config) {
        if (inited) {
            return initStatus;
        }
        inited = true;
        long start = System.currentTimeMillis();
        if (config == null) {
            config = new ConfigBuilder().build();
        }
        ShadowHook.init((ShadowHook.Config)new ShadowHook.ConfigBuilder().setLibLoader(config.getShadowhookLibLoader()).setMode(config.getShadowhookMode()).setDebuggable(config.getShadowhookDebug()).setRecordable(config.getShadowhookRecordable()).build());
        try {
            if (config.getLibLoader() == null) {
                System.loadLibrary(libName);
            } else {
                config.getLibLoader().loadLibrary(libName);
            }
        }
        catch (Throwable ignored) {
            initStatus = 100;
            initCostMs = System.currentTimeMillis() - start;
            return initStatus;
        }
        try {
            initStatus = ByteHook.nativeInit(config.getMode(), config.getDebug());
        }
        catch (Throwable ignored) {
            initStatus = 101;
        }
        if (config.getRecordable()) {
            try {
                ByteHook.nativeSetRecordable(config.getRecordable());
            }
            catch (Throwable ignored) {
                initStatus = 101;
            }
        }
        initCostMs = System.currentTimeMillis() - start;
        return initStatus;
    }

    public static int addIgnore(String callerPathName) {
        if (initStatus == 0) {
            return ByteHook.nativeAddIgnore(callerPathName);
        }
        return initStatus;
    }

    public static int getInitErrno() {
        return initStatus;
    }

    public static long getInitCostMs() {
        return initCostMs;
    }

    public static Mode getMode() {
        if (initStatus == 0) {
            return Mode.AUTOMATIC.getValue() == ByteHook.nativeGetMode() ? Mode.AUTOMATIC : Mode.MANUAL;
        }
        return Mode.AUTOMATIC;
    }

    public static boolean getDebug() {
        if (initStatus == 0) {
            return ByteHook.nativeGetDebug();
        }
        return false;
    }

    public static void setDebug(boolean debug) {
        if (initStatus == 0) {
            ByteHook.nativeSetDebug(debug);
        }
    }

    public static boolean getRecordable() {
        if (initStatus == 0) {
            return ByteHook.nativeGetRecordable();
        }
        return false;
    }

    public static void setRecordable(boolean recordable) {
        if (initStatus == 0) {
            ByteHook.nativeSetRecordable(recordable);
        }
    }

    public static String getRecords(RecordItem ... recordItems) {
        if (initStatus == 0) {
            int itemFlags = 0;
            block10: for (RecordItem recordItem : recordItems) {
                switch (recordItem) {
                    case TIMESTAMP: {
                        itemFlags |= 1;
                        continue block10;
                    }
                    case CALLER_LIB_NAME: {
                        itemFlags |= 2;
                        continue block10;
                    }
                    case OP: {
                        itemFlags |= 4;
                        continue block10;
                    }
                    case LIB_NAME: {
                        itemFlags |= 8;
                        continue block10;
                    }
                    case SYM_NAME: {
                        itemFlags |= 0x10;
                        continue block10;
                    }
                    case NEW_ADDR: {
                        itemFlags |= 0x20;
                        continue block10;
                    }
                    case ERRNO: {
                        itemFlags |= 0x40;
                        continue block10;
                    }
                    case STUB: {
                        itemFlags |= 0x80;
                        continue block10;
                    }
                }
            }
            if (itemFlags == 0) {
                itemFlags = 255;
            }
            return ByteHook.nativeGetRecords(itemFlags);
        }
        return null;
    }

    public static String getArch() {
        if (initStatus == 0) {
            return ByteHook.nativeGetArch();
        }
        return "unknown";
    }

    private static native String nativeGetVersion();

    private static native int nativeInit(int var0, boolean var1);

    private static native int nativeAddIgnore(String var0);

    private static native int nativeGetMode();

    private static native boolean nativeGetDebug();

    private static native void nativeSetDebug(boolean var0);

    private static native boolean nativeGetRecordable();

    private static native void nativeSetRecordable(boolean var0);

    private static native String nativeGetRecords(int var0);

    private static native String nativeGetArch();

    static /* synthetic */ ILibLoader access$000() {
        return defaultLibLoader;
    }

    static /* synthetic */ int access$100() {
        return defaultMode;
    }

    static /* synthetic */ ShadowHook.ILibLoader access$200() {
        return defaultShadowhookLibLoader;
    }

    static /* synthetic */ ShadowHook.Mode access$300() {
        return defaultShadowhookMode;
    }

    public static class Config {
        private ILibLoader libLoader;
        private int mode;
        private boolean debug;
        private boolean recordable;
        private ShadowHook.ILibLoader shadowhookLibLoader;
        private ShadowHook.Mode shadowhookMode;
        private boolean shadowhookDebug;
        private boolean shadowhookRecordable;

        public void setLibLoader(ILibLoader libLoader) {
            this.libLoader = libLoader;
        }

        public ILibLoader getLibLoader() {
            return this.libLoader;
        }

        public void setMode(int mode) {
            this.mode = mode;
        }

        public int getMode() {
            return this.mode;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public boolean getDebug() {
            return this.debug;
        }

        public void setRecordable(boolean recordable) {
            this.recordable = recordable;
        }

        public boolean getRecordable() {
            return this.recordable;
        }

        public void setShadowhookLibLoader(ShadowHook.ILibLoader libLoader) {
            this.shadowhookLibLoader = libLoader;
        }

        public ShadowHook.ILibLoader getShadowhookLibLoader() {
            return this.shadowhookLibLoader;
        }

        public void setShadowhookMode(ShadowHook.Mode mode) {
            this.shadowhookMode = mode;
        }

        public ShadowHook.Mode getShadowhookMode() {
            return this.shadowhookMode;
        }

        public void setShadowhookDebug(boolean debug) {
            this.shadowhookDebug = debug;
        }

        public boolean getShadowhookDebug() {
            return this.shadowhookDebug;
        }

        public void setShadowhookRecordable(boolean recordable) {
            this.shadowhookRecordable = recordable;
        }

        public boolean getShadowhookRecordable() {
            return this.shadowhookRecordable;
        }
    }

    public static class ConfigBuilder {
        private ILibLoader libLoader = ByteHook.access$000();
        private int mode = ByteHook.access$100();
        private boolean debug = false;
        private boolean recordable = false;
        private ShadowHook.ILibLoader shadowhookLibLoader = ByteHook.access$200();
        private ShadowHook.Mode shadowhookMode = ByteHook.access$300();
        private boolean shadowhookDebug = false;
        private boolean shadowhookRecordable = false;

        public ConfigBuilder setLibLoader(ILibLoader libLoader) {
            this.libLoader = libLoader;
            return this;
        }

        public ConfigBuilder setMode(Mode mode) {
            this.mode = mode.getValue();
            return this;
        }

        public ConfigBuilder setDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public ConfigBuilder setRecordable(boolean recordable) {
            this.recordable = recordable;
            return this;
        }

        public ConfigBuilder setShadowhookLibLoader(ShadowHook.ILibLoader libLoader) {
            this.shadowhookLibLoader = libLoader;
            return this;
        }

        public ConfigBuilder setShadowhookMode(ShadowHook.Mode mode) {
            this.shadowhookMode = mode;
            return this;
        }

        public ConfigBuilder setShadowhookDebug(boolean debug) {
            this.shadowhookDebug = debug;
            return this;
        }

        public ConfigBuilder setShadowhookRecordable(boolean recordable) {
            this.shadowhookRecordable = recordable;
            return this;
        }

        public Config build() {
            Config config = new Config();
            config.setLibLoader(this.libLoader);
            config.setMode(this.mode);
            config.setDebug(this.debug);
            config.setRecordable(this.recordable);
            config.setShadowhookLibLoader(this.shadowhookLibLoader);
            config.setShadowhookMode(this.shadowhookMode);
            config.setShadowhookDebug(this.shadowhookDebug);
            config.setShadowhookRecordable(this.shadowhookRecordable);
            return config;
        }
    }

    public static enum Mode {
        AUTOMATIC(0),
        MANUAL(1);

        private final int value;

        private Mode(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum RecordItem {
        TIMESTAMP,
        CALLER_LIB_NAME,
        OP,
        LIB_NAME,
        SYM_NAME,
        NEW_ADDR,
        ERRNO,
        STUB;

    }
}

