/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.api.compat

import java.io.File

/**
 * Created by ChengTao(chentao.joe@bytedance.com) on 2023/3/2.
 */
fun String.capitalizeUS(): String {
    val string = this
    return buildString {
        string.forEachIndexed { index, char ->
            if (index == 0 && Character.isLowerCase(char)) {
                append(Character.toTitleCase(char))
            } else {
                append(char)
            }
        }
    }
}

fun String.toSystemPath() = this.replace("/", File.separator)