/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater;

import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.AbsCodeGenerator;
import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.ViewCreatorCodeGenerator;
import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model.AppCompatViewCreatorModel;
import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model.IGenerateModel;
import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model.NormalViewCreatorModel;
import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model.RawViewCreatorModel;
import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model.ViewCreationCondition;
import com.bytedance.ultimate.inflater.plugin.internal.config.ConfigManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nR\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/bytedance/ultimate/inflater/plugin/internal/codegen/inflater/ViewCreatorCodeGenerator;", "Lcom/bytedance/ultimate/inflater/plugin/internal/codegen/inflater/AbsCodeGenerator;", "rawDatModel", "Lcom/bytedance/ultimate/inflater/plugin/internal/codegen/inflater/model/RawViewCreatorModel;", "(Lcom/bytedance/ultimate/inflater/plugin/internal/codegen/inflater/model/RawViewCreatorModel;)V", "_simpleClassName", "", "_viewClassName", "appCompatViewInflateClass", "getAppCompatViewInflateClass", "()Ljava/lang/String;", "appCompatViewInflateClass$delegate", "Lkotlin/Lazy;", "classPackage", "getClassPackage", "isAppCompatView", "", "simpleClassName", "getSimpleClassName", "templateName", "getTemplateName", "viewClassName", "getViewClassName", "viewName", "createAppCompatViewCreatorModel", "Lcom/bytedance/ultimate/inflater/plugin/internal/codegen/inflater/model/AppCompatViewCreatorModel;", "createDataModel", "Lcom/bytedance/ultimate/inflater/plugin/internal/codegen/inflater/model/IGenerateModel;", "getViewClassNameByViewName", "Companion", "ultimate-inflater-plugin-api"})
public final class ViewCreatorCodeGenerator
extends AbsCodeGenerator {
    private final String viewName;
    private final String _simpleClassName;
    private boolean isAppCompatView;
    private final Lazy appCompatViewInflateClass$delegate;
    private String _viewClassName;
    private static final String PACKAGE = "com.bytedance.ultimate.inflater.internal.ui.view";
    private static final String NORMAL_TEMPLATE = "NormalViewCreator";
    private static final String APP_COMPAT_TEMPLATE = "AppCompatViewCreator";
    private static final Set<String> supportAppCompatViews;
    private static final Set<String> androidxAppCompatViews;
    private static final Map<String, String> materialAppCompatViews;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getClassPackage() {
        return PACKAGE;
    }

    @Override
    @NotNull
    public String getTemplateName() {
        return this.isAppCompatView ? APP_COMPAT_TEMPLATE : NORMAL_TEMPLATE;
    }

    @Override
    @NotNull
    public String getSimpleClassName() {
        return this._simpleClassName;
    }

    private final String getAppCompatViewInflateClass() {
        Lazy lazy = this.appCompatViewInflateClass$delegate;
        ViewCreatorCodeGenerator viewCreatorCodeGenerator = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final String getViewClassName() {
        String string2 = this._viewClassName;
        if (string2 == null) {
            throw (Throwable)new IllegalStateException("Cannot get view class name.");
        }
        return string2;
    }

    @Override
    @NotNull
    public IGenerateModel createDataModel() {
        String viewClassName;
        this._viewClassName = viewClassName = StringsKt.contains$default((CharSequence)this.viewName, (CharSequence)".", (boolean)false, (int)2, null) ? this.viewName : this.getViewClassNameByViewName(this.viewName);
        if (this.isAppCompatView) {
            return this.createAppCompatViewCreatorModel();
        }
        boolean isRequireMainThread = ConfigManager.INSTANCE.isViewRequireMainThread(viewClassName);
        boolean isRequireActivityContext = ConfigManager.INSTANCE.isViewRequireActivityContext(viewClassName);
        boolean hasViewCreationCondition = isRequireMainThread || isRequireActivityContext;
        String layoutInflaterFactory = ConfigManager.INSTANCE.getLayoutInflaterFactory(viewClassName);
        boolean isDefaultLayoutInflaterFactory = Intrinsics.areEqual((Object)layoutInflaterFactory, (Object)"default");
        return new NormalViewCreatorModel(this.getClassPackage(), this.getClassName(), this.getSimpleClassName(), viewClassName, hasViewCreationCondition, isRequireMainThread, isRequireActivityContext, isDefaultLayoutInflaterFactory, layoutInflaterFactory);
    }

    /*
     * WARNING - void declaration
     */
    private final AppCompatViewCreatorModel createAppCompatViewCreatorModel() {
        void $this$mapTo$iv$iv;
        Object materialViewClassName;
        boolean bl = false;
        Map conditionToViewClassName = new LinkedHashMap();
        boolean hasMaterialAppCompatView = false;
        String widgetViewClassName = this.getViewClassName();
        conditionToViewClassName.put("Widget", widgetViewClassName);
        if (Intrinsics.areEqual((Object)this.getAppCompatViewInflateClass(), (Object)"androidx") || Intrinsics.areEqual((Object)this.getAppCompatViewInflateClass(), (Object)"androidx-material")) {
            conditionToViewClassName.put("AndroidXAppCompat", "androidx.appcompat.widget.AppCompat" + this.viewName);
        }
        if (Intrinsics.areEqual((Object)this.getAppCompatViewInflateClass(), (Object)"support") || Intrinsics.areEqual((Object)this.getAppCompatViewInflateClass(), (Object)"support-material")) {
            conditionToViewClassName.put("SupportAppCompat", "android.support.v7.widget.AppCompat" + this.viewName);
        }
        if (Intrinsics.areEqual((Object)this.getAppCompatViewInflateClass(), (Object)"androidx-material") || Intrinsics.areEqual((Object)this.getAppCompatViewInflateClass(), (Object)"support-material")) {
            String string2 = materialAppCompatViews.get(this.viewName);
            if (string2 != null) {
                String string3 = string2;
                boolean bl2 = false;
                boolean bl3 = false;
                materialViewClassName = string3;
                boolean bl4 = false;
                conditionToViewClassName.put("MaterialAppCompat", materialViewClassName);
                hasMaterialAppCompatView = true;
            }
        }
        Map $this$map$iv = conditionToViewClassName;
        boolean $i$f$map = false;
        materialViewClassName = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var10_12 = $this$mapTo$iv$iv;
        boolean bl5 = false;
        Iterator iterator = var10_12.entrySet().iterator();
        while (iterator.hasNext()) {
            void condition;
            void $dstr$condition$viewClassName;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            void var16_19 = $dstr$condition$viewClassName;
            boolean bl7 = false;
            String string4 = (String)var16_19.getKey();
            var16_19 = $dstr$condition$viewClassName;
            bl7 = false;
            String viewClassName = (String)var16_19.getValue();
            boolean isRequireMainThread = ConfigManager.INSTANCE.isViewRequireMainThread(viewClassName);
            boolean isRequireActivityContext = ConfigManager.INSTANCE.isViewRequireActivityContext(viewClassName);
            boolean hasCondition = isRequireMainThread || isRequireActivityContext;
            String layoutInflaterFactory = ConfigManager.INSTANCE.getLayoutInflaterFactory(viewClassName);
            boolean isDefaultLayoutInflaterFactory = Intrinsics.areEqual((Object)layoutInflaterFactory, (Object)"default");
            ViewCreationCondition viewCreationCondition = new ViewCreationCondition((String)condition, this.viewName, viewClassName, hasCondition, isRequireMainThread, isRequireActivityContext, isDefaultLayoutInflaterFactory, layoutInflaterFactory);
            collection.add(viewCreationCondition);
        }
        List viewCreationConditionList = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        viewCreationConditionList.add(new ViewCreationCondition("Automatic", this.viewName, this.viewName, true, ConfigManager.INSTANCE.isViewRequireMainThread(this.viewName), true, true, "default"));
        return new AppCompatViewCreatorModel(this.getClassPackage(), this.getClassName(), this.getSimpleClassName(), hasMaterialAppCompatView, viewCreationConditionList);
    }

    private final String getViewClassNameByViewName(String viewName) {
        String string2;
        switch (viewName) {
            case "fragment": 
            case "blank": {
                throw (Throwable)new IllegalStateException("cannot create view name with : " + viewName);
            }
            case "ViewStub": 
            case "TextureView": 
            case "View": 
            case "SurfaceView": {
                string2 = "android.view." + viewName;
                break;
            }
            case "FragmentBreadCrumbs": 
            case "MediaRouteButton": {
                string2 = "android.app." + viewName;
                break;
            }
            case "WebView": {
                string2 = "android.webkit." + viewName;
                break;
            }
            default: {
                string2 = "android.widget." + viewName;
            }
        }
        return string2;
    }

    public ViewCreatorCodeGenerator(@NotNull RawViewCreatorModel rawDatModel) {
        Intrinsics.checkParameterIsNotNull((Object)rawDatModel, (String)"rawDatModel");
        this.appCompatViewInflateClass$delegate = LazyKt.lazy((Function0)appCompatViewInflateClass.2.INSTANCE);
        String viewName = rawDatModel.getNode().getViewName();
        if (Intrinsics.areEqual((Object)viewName, (Object)"view")) {
            viewName = (String)rawDatModel.getNode().requireAttribute("class");
        }
        this.viewName = viewName;
        this._simpleClassName = StringsKt.replace$default((String)viewName, (String)".", (String)"_", (boolean)false, (int)4, null) + "_ViewCreator";
        if (!StringsKt.contains$default((CharSequence)viewName, (CharSequence)".", (boolean)false, (int)2, null)) {
            this.isAppCompatView = supportAppCompatViews.contains(viewName);
            if (!this.isAppCompatView && (Intrinsics.areEqual((Object)this.getAppCompatViewInflateClass(), (Object)"androidx") || Intrinsics.areEqual((Object)this.getAppCompatViewInflateClass(), (Object)"androidx-material"))) {
                this.isAppCompatView = androidxAppCompatViews.contains(viewName);
            }
        }
    }

    static {
        Companion = new Companion(null);
        supportAppCompatViews = SetsKt.setOf((Object[])new String[]{"TextView", "ImageView", "Button", "EditText", "Spinner", "ImageButton", "CheckBox", "RadioButton", "CheckedTextView", "AutoCompleteTextView", "MultiAutoCompleteTextView", "RatingBar", "SeekBar"});
        androidxAppCompatViews = SetsKt.plus(supportAppCompatViews, (Object)"ToggleButton");
        materialAppCompatViews = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Button", (Object)"com.google.android.material.button.MaterialButton"), TuplesKt.to((Object)"CheckBox", (Object)"com.google.android.material.checkbox.MaterialCheckBox"), TuplesKt.to((Object)"RadioButton", (Object)"com.google.android.material.radiobutton.MaterialRadioButton"), TuplesKt.to((Object)"TextView", (Object)"com.google.android.material.textview.MaterialTextView"), TuplesKt.to((Object)"AutoCompleteTextView", (Object)"com.google.android.material.textfield.MaterialAutoCompleteTextView")});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/bytedance/ultimate/inflater/plugin/internal/codegen/inflater/ViewCreatorCodeGenerator$Companion;", "", "()V", "APP_COMPAT_TEMPLATE", "", "NORMAL_TEMPLATE", "PACKAGE", "androidxAppCompatViews", "", "materialAppCompatViews", "", "supportAppCompatViews", "ultimate-inflater-plugin-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

