/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin

/**
 * Created by ChengTao(chentao.joe@bytedance.com) on 2022/9/13.
 */
interface IUltimateInflaterExtension {

    /**
     * Class of AppCompatViewInflater to create Compat View such as TextView, Button etc.
     *
     * @return the class of AppCompatViewInflater, for some special cases you can use abbreviation.
     *
     * Following abbreviation :
     * - atomic
     * - widget
     * - androidx
     * - support
     * - androidx-material
     * - support-material
     */
    fun appCompatViewInflaterClass(): String

    companion object {
        // the extension name of "UltimateInflater" plugin
        const val NAME = "ultimateInflater"

        // region : CompatViewInflater

        // atomic indicates creating compat view will be done automate.
        const val APP_COMPAT_VIEW_INFLATER_AUTOMATIC = "automatic"

        // widget indicates creating compat view will be with prefix "android.widget".
        //
        // example following:
        // TextView -> android.widget.TextView
        // Button -> android.widget.Button
        // ...
        const val APP_COMPAT_VIEW_INFLATER_WIDGET = "widget"

        // androidx indicates creating compat view will be with prefix "androidx.appcompat.widget"
        // and transform to compat view.
        //
        // example following:
        // TextView -> androidx.appcompat.widget.AppCompatTextView
        // Button -> androidx.appcompat.widget.AppCompatButton
        // ...
        //
        // refer to "androidx.appcompat.app.AppCompatViewInflater"
        const val APP_COMPAT_VIEW_INFLATER_ANDROIDX = "androidx"

        // androidx-material indicates creating compat view will be with prefix
        // "com.google.android.material" and transform to compat view.
        // If some compat views has no corresponding material compat views, it will be created by
        // "androidx.appcompat.app.AppCompatViewInflater".
        //
        // example following:
        // TextView -> com.google.android.material.textview.MaterialTextView
        // Button -> com.google.android.material.button.MaterialButton
        // ...
        //
        // refer to "com.google.android.material.theme.MaterialComponentsViewInflater"
        const val APP_COMPAT_VIEW_INFLATER_ANDROIDX_MATERIAL = "androidx-material"

        // support indicates creating compat view will be with prefix "android.support.v7.widget"
        // and transform to compat view.
        //
        // example following:
        // TextView -> android.support.v7.widget.AppCompatTextView
        // Button -> android.support.v7.widget.AppCompatButton
        // ...
        //
        // refer to "android.support.v7.app.AppCompatViewInflater"
        const val APP_COMPAT_VIEW_INFLATER_SUPPORT = "support"

        // support-material indicates creating compat view will be with prefix
        // "com.google.android.material" and transform to compat view.
        // If some compat views has no corresponding material compat views, it will be created by
        // "android.support.v7.app.AppCompatViewInflater".
        //
        // example following:
        // TextView -> com.google.android.material.textview.MaterialTextView
        // Button -> com.google.android.material.button.MaterialButton
        // ...
        //
        // refer to "com.google.android.material.theme.MaterialComponentsViewInflater"
        const val APP_COMPAT_VIEW_INFLATER_SUPPORT_MATERIAL = "support-material"

        // endregion
    }
}