/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.arsc

import java.lang.reflect.Field

/**
 * Created by chentao.joe on 2022/8/20
 * @author chentao.joe@bytedance.com
 */
data class ResTableTypeSpec(
    @unit_size_t_group
    val header: ResChunkHeader,
    @unit_8_t
    val id: Int,
    @unit_8_t
    val res0: Int,
    @unit_16_t
    val res1: Int,
    @unit_32_t
    val entryCount: Int,
    @FieldCast(FieldEntriesCaster::class)
    val entries: List<EntryInfo>
) {

    data class EntryInfo(
        val data: List<Byte>,
        val hex: String
    )

    class FieldEntriesCaster : DefaultFieldCaster<List<EntryInfo>>() {

        private val entryCount: Int by lazy { getFieldValue<Int>("entryCount") }

        override fun getFieldSize(field: Field, value: List<EntryInfo>): Int = entryCount * 4

        override fun cast(field: Field, byteList: ByteList): List<EntryInfo> {
            return byteList.subList(0, 4 * entryCount)
                .chunked(4)
                .map { EntryInfo(it, it.toHex()) }
        }
    }

}