/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.arsc.single

import com.bytedance.ultimate.inflater.plugin.arsc.ResStringPoolRef
import com.bytedance.ultimate.inflater.plugin.arsc.unCast
import java.lang.reflect.Field

/**
 * Created by ChengTao(chentao.joe@bytedance.com) on 2022/8/15.
 */
abstract class AbsReplaceResStringPoolRefResXmlTreeChunkGenerator : IResXmlTreeChunkGenerator {

    abstract fun getUnCastObject(chain: IResXmlTreeChunkGenerator.Chain): Any

    override fun generate(chain: IResXmlTreeChunkGenerator.Chain): List<Byte> {
        val stringPoolIndexMap = chain.intermediate.resStringPoolIndexMap
        return getUnCastObject(chain)
            .unCast(object : ResXmlTreeFieldUnCastInterceptor() {
                override fun interceptResStringPoolRef(
                    field: Field,
                    ref: ResStringPoolRef
                ): List<Byte> {
                    return ResStringPoolRef(stringPoolIndexMap[ref]).unCast()
                }
            })
            .plus(chain.process())
    }
}