/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.arsc.single

/**
 * Created by chentao.joe on 2022/8/14
 * @author chentao.joe@bytedance.com
 */
interface IResXmlTreeChunkGenerator {

    fun generate(chain: Chain): List<Byte>

    interface Chain {
        val intermediate: Intermediate

        fun process(): List<Byte>
    }
}

class Intermediate {

    private var _namespaceCount = 0

    val namespaceCount: Int
        get() = _namespaceCount

    fun updateNameSpaceCount(count: Int) {
        _namespaceCount = count
    }

    private lateinit var _resStringPoolIndexMap: ResStringPoolIndexMap

    val resStringPoolIndexMap: ResStringPoolIndexMap
        get() = _resStringPoolIndexMap

    fun setResStringPoolIndexMap(map: ResStringPoolIndexMap) {
        if (this::_resStringPoolIndexMap.isInitialized) {
            throw IllegalStateException("Cannot set resStringPoolIndexMap twice.")
        }
        _resStringPoolIndexMap = map
    }
}