/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.arsc.single

/**
 * Created by chentao.joe on 2022/8/15
 * @author chentao.joe@bytedance.com
 */
class RealResXmlTreeChunkGeneratorChain(
    private val index: Int,
    private val generators: List<IResXmlTreeChunkGenerator>,
    override val intermediate: Intermediate
) : IResXmlTreeChunkGenerator.Chain {

    override fun process(): List<Byte> {
        val chain = RealResXmlTreeChunkGeneratorChain(index + 1, generators, intermediate)
        val generator = generators[index]
        return generator.generate(chain)
    }
}