/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.arsc.single

import com.bytedance.ultimate.inflater.plugin.arsc.*
import java.lang.reflect.Field

/**
 * Created by ChengTao(chentao.joe@bytedance.com) on 2022/8/15.
 */
open class ResXmlTreeFieldUnCastInterceptor : UnCastInterceptor {

    // ResXmlChunkHeader
    open fun interceptResXmlChunkHeaderSize(field: Field, value: Any): List<Byte>? = null

    // ResStringPoolHeader
    open fun interceptResStringPoolHeaderStyleCount(field: Field, value: Any): List<Byte>? = null

    open fun interceptResStringPoolHeaderStringCount(field: Field, value: Any): List<Byte>? = null

    open fun interceptResStringPoolHeaderStringsStart(field: Field, value: Any): List<Byte>? = null

    open fun interceptResStringPoolHeaderStylesStart(field: Field, value: Any): List<Byte>? = null

    // ResStringPool
    open fun interceptResStringPoolEntries(field: Field, value: Any): List<Byte>? = null

    open fun interceptResStringPoolEntryStyles(field: Field, value: Any): List<Byte>? = null

    open fun interceptResStringPoolStrings(field: Field, value: Any): List<Byte>? = null

    open fun interceptResStringPoolStyles(field: Field, value: Any): List<Byte>? = null

    // ResResourceMap
    open fun interceptResResourceMapResIds(field: Field, value: Any): List<Byte>? = null

    // ResStringPoolRef

    open fun interceptResStringPoolRef(field: Field, ref: ResStringPoolRef): List<Byte>? = null

    final override fun intercept(field: Field, value: Any): List<Byte>? {
        return when {
            // ResXmlChunkHeader
            field == ResChunkHeader::class.java.getDeclaredField("size") -> {
                interceptResXmlChunkHeaderSize(field, value)
            }

            // ResStringPoolHeader
            field == ResStringPoolHeader::class.java.getDeclaredField("stringCount") -> {
                interceptResStringPoolHeaderStringCount(field, value)
            }

            field == ResStringPoolHeader::class.java.getDeclaredField("styleCount") -> {
                interceptResStringPoolHeaderStyleCount(field, value)
            }

            field == ResStringPoolHeader::class.java.getDeclaredField("stringsStart") -> {
                interceptResStringPoolHeaderStringsStart(field, value)
            }

            field == ResStringPoolHeader::class.java.getDeclaredField("stylesStart") -> {
                interceptResStringPoolHeaderStylesStart(field, value)
            }

            // ResStringPool
            field == ResStringPool::class.java.getDeclaredField("entries") -> {
                interceptResStringPoolEntries(field, value)
            }

            field == ResStringPool::class.java.getDeclaredField("entryStyles") -> {
                interceptResStringPoolEntryStyles(field, value)
            }

            field == ResStringPool::class.java.getDeclaredField("strings") -> {
                interceptResStringPoolStrings(field, value)
            }

            field == ResStringPool::class.java.getDeclaredField("styles") -> {
                interceptResStringPoolStyles(field, value)
            }

            // ResXmlResourceMap
            field == ResXmlResourceMap::class.java.getDeclaredField("resIds") -> {
                interceptResResourceMapResIds(field, value)
            }

            // ResStringPoolRef
            field.type == ResStringPoolRef::class.java -> {
                interceptResStringPoolRef(field, value as ResStringPoolRef)
            }

            else -> null
        }
    }
}