/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.arsc.single

import com.bytedance.ultimate.inflater.plugin.arsc.*

/**
 * Created by chentao.joe on 2022/8/15
 * @author chentao.joe@bytedance.com
 */
class ResXmlTreeGenerator(
    private val element: ResXmlTreeNodeElement,
    private val namespaces: List<ResXmlTreeNodeNamespace>
) : IResXmlTreeChunkGenerator {
    override fun generate(chain: IResXmlTreeChunkGenerator.Chain): List<Byte> {
        chain.intermediate.setResStringPoolIndexMap(ResStringPoolIndexMap(element, namespaces))
        return chain.process()
    }

    companion object {
        fun elementAsResXmlTree(
            header: ResXmlTreeHeader,
            stringPool: ResStringPool,
            resourceMap: ResXmlResourceMap,
            namespaces: List<ResXmlTreeNodeNamespace>,
            element: ResXmlTreeNodeElement
        ): List<Byte> {
            val generators = mutableListOf<IResXmlTreeChunkGenerator>()
            generators += ResXmlTreeGenerator(element, namespaces)
            generators += ResXmlTreeHeaderGenerator(header)
            generators += ResStringPoolGenerator(stringPool)
            generators += ResXmlResourceMapGenerator(resourceMap)
            generators += ResXmlTreeStartNamespaceGenerator(namespaces.map { it.start })
            generators += ResXmlTreeStartElementGenerator(element.start)
            generators += ResXmlTreeEndElementGenerator(element.end)
            generators += ResXmlTreeEndNamespaceGenerator(namespaces.map { it.end })
            generators += FinalResXmlTreeChunkGenerator()
            return RealResXmlTreeChunkGeneratorChain(0, generators, Intermediate()).process()
        }
    }
}