/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.arsc.single

import com.bytedance.ultimate.inflater.plugin.arsc.ResXmlTreeHeader
import com.bytedance.ultimate.inflater.plugin.arsc.sizeOf
import com.bytedance.ultimate.inflater.plugin.arsc.toByteList
import com.bytedance.ultimate.inflater.plugin.arsc.unCast
import java.lang.reflect.Field

/**
 * Created by chentao.joe on 2022/8/14
 * @author chentao.joe@bytedance.com
 */
class ResXmlTreeHeaderGenerator(
    private val header: ResXmlTreeHeader
) : IResXmlTreeChunkGenerator {

    override fun generate(chain: IResXmlTreeChunkGenerator.Chain): List<Byte> {
        val dataList = chain.process()
        val size = dataList.size + sizeOf(ResXmlTreeHeader::class.java)
        return header
            .unCast(object : ResXmlTreeFieldUnCastInterceptor() {
                override fun interceptResXmlChunkHeaderSize(field: Field, value: Any): List<Byte> {
                    return size.toByteList(sizeOf(field))
                }
            })
            .plus(dataList)
    }

}