/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.arsc.single

import com.bytedance.ultimate.inflater.plugin.arsc.ResXmlTreeStartNamespace
import com.bytedance.ultimate.inflater.plugin.arsc.getAllResStringPoolRefs


/**
 * Created by chentao.joe on 2022/8/14
 * @author chentao.joe@bytedance.com
 */
class ResXmlTreeStartNamespaceGenerator(
    private val namespaces: List<ResXmlTreeStartNamespace>
) : AbsReplaceResStringPoolRefResXmlTreeChunkGenerator() {

    private lateinit var validNamespaces: List<ResXmlTreeStartNamespace>

    override fun getUnCastObject(chain: IResXmlTreeChunkGenerator.Chain): Any = validNamespaces

    override fun generate(chain: IResXmlTreeChunkGenerator.Chain): List<Byte> {
        val stringPoolIndexMap = chain.intermediate.resStringPoolIndexMap
        validNamespaces = namespaces
            .filter { namespace ->
                namespace.getAllResStringPoolRefs()?.any { stringPoolIndexMap.contains(it) } == true
            }
        chain.intermediate.updateNameSpaceCount(validNamespaces.size)
        return super.generate(chain)
    }
}