/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.internal

import com.android.build.gradle.api.BaseVariant
import org.gradle.api.Project
import org.gradle.plugins.ide.idea.model.IdeaModel
import java.io.File

/**
 * Created by ChengTao(chentao.joe@bytedance.com) on 2022/9/13.
 */
internal object Helper {
    /**
     * create generated source root for UltimateInflater
     *
     * @param project the [Project]
     * @param variant the [BaseVariant]
     *
     * @return source root file
     */
    fun createGeneratedSourceRoot(project: Project, variant: BaseVariant): File {
        val sourceRoot = File(
            project.buildDir, "generated/source/ultimateInflater/${variant.name}".toSystemPath()
        )
        if (project.plugins.hasPlugin("idea").not()) {
            project.plugins.apply("idea")
        }
        project.extensions.getByType(IdeaModel::class.java).module.apply {
            generatedSourceDirs = generatedSourceDirs + sourceRoot
        }
        return sourceRoot
    }
}