/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater

import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model.IGenerateModel
import com.github.mustachejava.DefaultMustacheFactory
import java.io.File
import java.io.FileWriter
import java.io.Writer

/**
 * Created by chentao.joe on 2022/7/29
 * @author chentao.joe@bytedance.com
 */
internal abstract class AbsCodeGenerator : CodeGenerator {

    abstract val classPackage: String

    abstract val templateName: String

    final override val className: String
        get() = "$classPackage.$simpleClassName"

    abstract fun createDataModel(): IGenerateModel


    protected open fun preGenerateJavaSource() {

    }

    protected open fun postGenerateJavaSource() {

    }

    final override fun generateJavaSource(dir: File) {
        preGenerateJavaSource()
        val sourceDir = File(dir, classPackage.replace(".", File.separator))
        if (sourceDir.exists().not()) {
            sourceDir.mkdirs()
        }
        val javaFile = File(sourceDir, "${simpleClassName}.java")
        FileWriter(javaFile).use { writer ->
            mustacheFactory.compile("template/${templateName}.java.mustache").execute(
                writer, createDataModel()
            )
        }
        postGenerateJavaSource()
    }

    companion object {
        private val mustacheFactory by lazy {
            object : DefaultMustacheFactory() {
                override fun encode(value: String, writer: Writer) {
                    writer.write(value)
                }
            }
        }
    }
}