/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater

import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model.IGenerateModel
import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model.LayoutCreatorFactoryRegistryModelList
import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model.LayoutIdToFactory
import com.bytedance.ultimate.inflater.plugin.internal.simpleClassName
import com.bytedance.ultimate.inflater.plugin.internal.toHex


/**
 * Created by ChengTao(chentao.joe@bytedance.com) on 2022/9/7.
 */
internal class LayoutCreatorFactoryRegistryImplCodeGenerator(
    private val layoutIdToFactory: LayoutIdToFactory
) : AbsCodeGenerator(), IntermediateCodeGenerator {

    private val otherLayoutIdToFactoryList = mutableListOf<LayoutIdToFactory>()
    override val classPackage: String
        get() = "com.bytedance.ultimate.inflater.internal.spi"

    override val simpleClassName: String
        get() = "LayoutCreatorFactoryRegistryImpl"

    override val templateName: String
        get() = TEMPLATE

    override fun createDataModel(): IGenerateModel {
        val layoutIdToFactoryList = otherLayoutIdToFactoryList
            .plus(layoutIdToFactory)
            .filter { it != LayoutIdToFactory.NONE }
            .associateBy { it.layoutId }
            .values.toList()
        val importClassList = layoutIdToFactoryList.map { it.factoryClassName }.toList()
        val layoutIdToFactorySimpleClassList = layoutIdToFactoryList
            .map {
                LayoutIdToFactory(
                    it.layoutId,
                    it.layoutId.toHex(),
                    it.factoryClassName.simpleClassName()
                )
            }
            .toList()
        return LayoutCreatorFactoryRegistryModelList(
            classPackage,
            className,
            simpleClassName,
            importClassList,
            layoutIdToFactorySimpleClassList
        )
    }

    override fun compose(others: List<IntermediateCodeGenerator>) {
        val candidates = others.filterIsInstance<LayoutCreatorFactoryRegistryImplCodeGenerator>()
        if (candidates.size != others.size) {
            throw IllegalStateException("size of candidates and others are not same.")
        }
        otherLayoutIdToFactoryList
            .also { it.clear() }
            .addAll(candidates.map { it.layoutIdToFactory })
    }

    companion object {
        private const val TEMPLATE = "LayoutCreatorFactoryRegistryImpl"
    }
}