/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater

import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model.IGenerateModel
import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model.LayoutNameToId
import com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model.LayoutNameToIdList


/**
 * Created by ChengTao(chentao.joe@bytedance.com) on 2022/9/7.
 */
internal class LayoutNameToIdRegistryImplCodeGenerator(
    private val layoutNameToId: LayoutNameToId
) : AbsCodeGenerator(), IntermediateCodeGenerator {

    private val otherLayoutNameToIdList = mutableListOf<LayoutNameToId>()

    override val classPackage: String
        get() = "com.bytedance.ultimate.inflater.internal.spi"

    override val simpleClassName: String
        get() = "LayoutNameToIdRegistryImpl"

    override val templateName: String
        get() = TEMPLATE

    override fun createDataModel(): IGenerateModel {
        return LayoutNameToIdList(
            classPackage,
            className,
            simpleClassName,
            otherLayoutNameToIdList
                .plus(layoutNameToId)
                .filter { it != LayoutNameToId.NONE }
                .associateBy { it.layoutName }
                .values.toList()
                .sortedBy { it.layoutId }
        )
    }

    override fun compose(others: List<IntermediateCodeGenerator>) {
        val candidates = others.filterIsInstance<LayoutNameToIdRegistryImplCodeGenerator>()
        if (candidates.size != others.size) {
            throw IllegalStateException("size of candidates and others are not same.")
        }
        otherLayoutNameToIdList.also { it.clear() }.addAll(candidates.map { it.layoutNameToId })
    }

    companion object {
        private const val TEMPLATE = "LayoutNameToIdRegistryImpl"
    }
}