/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model

internal data class LayoutCreatorFactoryVariantModel(
    override val classPackage: String,
    override val className: String,
    override val simpleClassName: String,
    val layoutId: Int,
    val isMergeLayout: Boolean,
    val importClassList: List<String>,
    val appCompatViewInflaterClass: String,
    val viewCreatorList: List<LayoutViewCreatorModel>
) : IGenerateModel

internal data class LayoutViewCreatorModel(
    val viewCreatorClassName: String?,
    val viewCreatorSimpleClassName: String?,
    val attributeDataProviderSimpleClassName: String,
    val attributeDataString: String,
    val selfVal: String?,
    val parentVal: String?,
    val themeId: Int?,
    /*include*/
    val isInclude: Boolean,
    val includeLayoutId: Int?,
    val includeLayoutName: String?,
    val includeId: Int?,
    val includeVisibility: Int?
)


internal data class LayoutCreatorFactoryModel(
    override val classPackage: String,
    override val className: String,
    override val simpleClassName: String,
    val layoutName: String,
    val importClassList: List<String>,
    val hasLand: Boolean,
    val hasMultipleVersion: Boolean,
    val landLayoutCreatorFactories: List<LayoutCreatorFactoryVariant>,
    val versionLayoutCreatorFactories: List<LayoutCreatorFactoryVariant>,
    val defaultCreatorFactory: LayoutCreatorFactoryVariant?
) : IGenerateModel

internal data class LayoutCreatorFactoryVariant(
    val className: String,
    val simpleClassName: String,
    val isLand: Boolean,
    val isDefault: Boolean,
    val version: Int,
    val hasVersion: Boolean
)