/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model

/**
 * Created by ChengTao(chentao.joe@bytedance.com) on 2022/9/8.
 */
internal data class LayoutIdToFactory(
    val layoutId: Int,
    val layoutIdHex: String,
    val factoryClassName: String
) {
    companion object {
        val NONE = LayoutIdToFactory(-1, "", "null")
    }
}

internal data class LayoutCreatorFactoryRegistryModelList(
    override val classPackage: String,
    override val className: String,
    override val simpleClassName: String,
    val importClassList: List<String>,
    val list: List<LayoutIdToFactory>
) : IGenerateModel
