/*
 * Copyright (C) 2023 ByteDance Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.bytedance.ultimate.inflater.plugin.internal.codegen.inflater.model

import com.bytedance.ultimate.inflater.plugin.arsc.single.SingleNodeResXmlTree


/**
 * Created by chentao.joe on 2022/7/29
 * @author chentao.joe@bytedance.com
 */
internal data class RawViewCreatorModel(val node: SingleNodeResXmlTree)

internal data class NormalViewCreatorModel(
    override val classPackage: String,
    override val className: String,
    override val simpleClassName: String,
    val viewClassName: String,
    val hasViewCreationCondition: Boolean,
    val isRequireMainTread: Boolean,
    val isRequireActivityContext: Boolean,
    val isDefaultLayoutInflaterFactory: Boolean,
    val layoutInflaterFactoryClassName: String?
) : IGenerateModel

internal data class AppCompatViewCreatorModel(
    override val classPackage: String,
    override val className: String,
    override val simpleClassName: String,
    val hasMaterialAppCompatView: Boolean,
    val viewCreationConditionList: List<ViewCreationCondition>
) : IGenerateModel

internal data class ViewCreationCondition(
    val condition: String,
    val viewName: String,
    val viewClassName: String,
    val hasCondition: Boolean,
    val isRequireMainTread: Boolean,
    val isRequireActivityContext: Boolean,
    val isDefaultLayoutInflaterFactory: Boolean,
    val layoutInflaterFactoryClassName: String?
)